/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.tenants;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.directories.OlapDirectoriesResolvedNotSuperAdminException;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.tenants.OlapTenantDefinition;
import crazydev.iccube.tenants.OlapTenantManager;
import crazydev.iccube.ux.admin.queries.tenants.UxAbstractTenantQuery;
import crazydev.iccube.ux.common.action.UxActionPerformed;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxRepairTenantHomeDirectoryQuery
extends UxAbstractTenantQuery {
    private final String uuid;
    private final boolean installDashboardApp;

    public UxRepairTenantHomeDirectoryQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String uuid, boolean installDashboardApp) {
        super(meta, requestId);
        this.uuid = uuid;
        this.installDashboardApp = installDashboardApp;
    }

    @Override
    protected UxReply doExecuteQuery(UxQueryContext queryContext) {
        if (!queryContext.isSuperAdministrator()) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.TENANT_NOT_GLOBAL_ADMINISTRATOR, (Serializable[])new Serializable[0]));
        }
        try {
            if (this.uuid == null || CdStringUtils.isNullOrBlank((String)this.uuid)) {
                return UxReply.actionSuccess();
            }
            OlapTenantManager manager = queryContext.getTenantManager();
            OlapTenantDefinition tenant = manager.getTenantDefinitionByUUID(this.uuid);
            if (tenant == null) {
                return UxReply.actionSuccess(new UxActionPerformed(false));
            }
            OlapDirectoriesResolved directories = queryContext.getResolvedDirectories();
            boolean done = manager.repairTenantHomeDirectory(directories, tenant, this.installDashboardApp);
            return UxReply.actionSuccess(new UxActionPerformed(done));
        }
        catch (OlapDirectoriesResolvedNotSuperAdminException ex) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.TENANT_NOT_GLOBAL_ADMINISTRATOR, (Serializable[])new Serializable[0]));
        }
    }
}

