/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema.partition;

import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.schema.OlapSchemaPartitionInformation;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import crazydev.iccube.ux.admin.queries.schema.UxAbstractSchemaQuery;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.common.filter.UxEnumFilterType;
import crazydev.iccube.ux.common.filter.UxFilterMeta;
import crazydev.iccube.ux.common.filter.UxFilterMetas;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableCell;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableMeta;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.common.table.UxTableRowSearcher;
import crazydev.iccube.ux.common.table.UxTableWithUseCasesReplyPayload;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class UxPartitionsQuery
extends UxAbstractSchemaQuery {
    private final String schemaName;

    protected UxPartitionsQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxTableOptions tableOptions, String schemaName) {
        super(meta, requestId, tableOptions);
        this.schemaName = schemaName;
    }

    @Override
    @Nullable
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public IcCubeSchemaAccessLockMode getSchemaAccessLockMode() {
        return IcCubeSchemaAccessLockMode.READ;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        UxBabylonService babylon = queryContext.getUxBabylonService();
        UxTableHeaders header = UxTableHeaders.create(babylon, "cube", "facts", "name", "kind");
        UxFilterMetas filterMetas = new UxFilterMetas(new UxFilterMeta<OlapSchemaPartitionInformation>("cube", babylon.translate("filterCubeName", new Serializable[0]), OlapSchemaPartitionInformation::getCube), new UxFilterMeta<OlapSchemaPartitionInformation>("facts", babylon.translate("filterFactsName", new Serializable[0]), OlapSchemaPartitionInformation::getFacts), new UxFilterMeta<OlapSchemaPartitionInformation>("name", babylon.translate("filterFactsName", new Serializable[0]), OlapSchemaPartitionInformation::getName), new UxFilterMeta<OlapSchemaPartitionInformation>("kind", babylon.translate("filterPartitionKind", new Serializable[0]), UxEnumFilterType.create(babylon, OlapSchemaPartitionInformation.Kind.class), OlapSchemaPartitionInformation::getKind));
        UxTableRowSearcher<OlapSchemaPartitionInformation> searcher = new UxTableRowSearcher<OlapSchemaPartitionInformation>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public boolean isAccepting(OlapSchemaPartitionInformation row, String searchText) {
                return this.isContaining(searchText, row.getName(), row.getCube(), row.getFacts());
            }
        };
        OlapEngineRequestContext eContext = queryContext.getOlapEngineRequestContext();
        OlapEngineComponent engine = queryContext.getOlapEngineComponent();
        List partitions = this.filter(this.tableOptions, searcher, filterMetas, engine.listSchemaPartitions(eContext, this.schemaName));
        int totalRowCount = partitions.size();
        UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.createForFirstPageWithDefaults(queryContext.getApi(), totalRowCount));
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        for (OlapSchemaPartitionInformation partition : partitions) {
            rows.add(UxPartitionsQuery.createRow(queryContext, partition));
        }
        UxTable table = UxTable.create(options, header, rows);
        UxTableMeta tableMeta = new UxTableMeta(searcher != null, filterMetas);
        return UxReply.success(new UxTableWithUseCasesReplyPayload(tableMeta, table));
    }

    private static UxTableRow createRow(UxQueryContext context, OlapSchemaPartitionInformation partition) {
        ArrayList<UxTableCell> cells = new ArrayList<UxTableCell>();
        cells.add(new UxTableCell(partition.getCube()));
        cells.add(new UxTableCell(partition.getFacts()));
        cells.add(new UxTableCell(partition.getName()));
        cells.add(new UxTableCell(partition.getKind().name()));
        return new UxTableRow(cells);
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxAdminUseCaseName.LoadedSchemas));
    }
}

