/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema.offline;

import crazydev.iccube.ux.admin.queries.schema.UxAbstractSchemaQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.lifecycle.UxRestoreOfflineQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.offline.UxDeleteOfflineQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.offline.UxDownloadOfflineQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.offline.UxOfflineInfoQuery;
import crazydev.iccube.ux.admin.queries.schema.offline.UxOfflinesQueryMeta;
import crazydev.iccube.ux.admin.queries.utils.UxArrays;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseRepository;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.url.UxUrl;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.usecase.UxUseCaseBuilder;
import crazydev.iccube.ux.common.usecase.UxUseCaseTitle;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxOfflineInfoQueryMeta
extends UxAbstractSchemaQueryMeta {
    public static final UxOfflineInfoQueryMeta OfflineInfo = new UxOfflineInfoQueryMeta();

    private UxOfflineInfoQueryMeta() {
        super(UxConsoleConstants.QueryName.OfflineInfo);
    }

    @Override
    public boolean isAuthorized(UxQueryContext context) {
        return UxOfflinesQueryMeta.Offlines.isAuthorized(context);
    }

    @Override
    public List<UxAction> createActions(UxQueryContext context) {
        return UxArrays.asList(new UxAction[0]);
    }

    @Override
    public UxQuery parseQuery(UxServerRequestParams params) throws UxQueryParserException {
        String name = params.getStringParameter("name");
        UxTableOptions tableOptions = params.getTableOptions();
        return new UxOfflineInfoQuery(this, params.getRequestId(), name, tableOptions);
    }

    public UxUrl createQueryUrl(String name) {
        return this.createQueryUrl().addParam("name", name);
    }

    public static UxUseCase createUseCase(UxQueryContext context, @Nullable String offline) {
        UxBabylonService babylon = context.getUxBabylonService();
        List<UxAction> actions = null;
        if (offline != null) {
            actions = OfflineInfo.createActions(context);
            actions.add(UxRestoreOfflineQueryMeta.createAction(context, offline));
            actions.add(UxDownloadOfflineQueryMeta.createAction(context, offline));
            actions.add(UxDeleteOfflineQueryMeta.createAction(context, offline));
        }
        return new UxUseCaseBuilder(context, OfflineInfo).withId(UxAdminUseCaseName.OfflineInfo.name() + "-" + offline).withCaption(babylon.translateUseCaseCaption(UxAdminUseCaseName.OfflineInfo.name(), new Serializable[0])).withUrl(OfflineInfo.createQueryUrl(offline)).withExtraTitle(new UxUseCaseTitle(context.getUseCase(UxAdminUseCaseName.Offlines), offline, UxAdminUseCaseRepository.asBookmark(OfflineInfo.createQueryUrl(offline)))).withActions(actions).build(true);
    }
}

