/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema.offline;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.fs.CdVFileSystem;
import crazydev.common.fs.CdZipOptions;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.fs.OlapFileSystem;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.schema.UxAbstractSchemaQuery;
import crazydev.iccube.ux.admin.queries.utils.UxFileWrapper;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxAttachmentReply;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxDownloadOfflineQuery
extends UxAbstractSchemaQuery {
    @Nullable
    private final String name;

    protected UxDownloadOfflineQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String name) {
        super(meta, requestId);
        this.name = name;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        File out;
        if (CdStringUtils.isNullOrBlank((String)this.name)) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.FILE_NOT_FOUND, (Serializable[])new Serializable[]{this.name}));
        }
        OlapDirectoriesResolved directories = queryContext.getResolvedDirectories();
        File offlines = directories.getOfflineDirectory();
        OlapFileSystem fs = OlapFileSystem.createFileSystem((CdVFileSystem)directories.getVfs(), (File)offlines);
        OlapFile snapshot = fs.create(this.name);
        if (!snapshot.exists()) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.FILE_NOT_FOUND, (Serializable[])new Serializable[]{this.name}));
        }
        if (!snapshot.isDirectory()) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.FILE_NOT_DIRECTORY, (Serializable[])new Serializable[]{this.name}));
        }
        CdVFileSystem vfs = directories.getVfs();
        File tmpDirectory = directories.getTmpDirectory();
        try {
            out = vfs.createTmpFileForDownload(tmpDirectory, "zip");
        }
        catch (IOException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[UX] could not create the snapshot zip", (Throwable)ex);
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.FILE_IO_ERROR, (Serializable[])new Serializable[]{this.name, ex.getMessage()}));
        }
        try {
            vfs.zip(CdZipOptions.withoutRoot(), out, new File[]{snapshot.__getUnderlying()});
        }
        catch (IOException ex) {
            vfs.delete(out);
            OlapLoggers.UX_REQUEST.error((Object)("[UX] unexpected error while compressing the snapshot [" + this.name + "]"), (Throwable)ex);
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.FILE_IO_ERROR, (Serializable[])new Serializable[]{"[" + this.name + "]", ex.getMessage()}));
        }
        String mimeType = queryContext.getMimeTypeByExtension(out.getName());
        OlapFileSystem fs_ = OlapFileSystem.createFileSystem((CdVFileSystem)directories.getVfs(), (File)out.getParentFile());
        OlapFile zip_ = fs_.create(out.getName());
        UxFileWrapper wrapper = UxFileWrapper.forOlapFile(zip_, snapshot.getName() + ".zip", mimeType, true);
        String attachmentName = this.name + ".zip";
        return new UxAttachmentReply(wrapper, attachmentName);
    }
}

