/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema.lifecycle;

import crazydev.iccube.olap.component.command.builtin.OlapLoadSchemaHelper;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLoadStatus;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import crazydev.iccube.ux.admin.queries.schema.lifecycle.UxAbstractSchemaLifeCycleQuery;
import crazydev.iccube.ux.admin.queries.schema.lifecycle.UxSchemaLifeCycleStatus;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import org.jetbrains.annotations.Nullable;

public class UxUnloadSchemaQuery
extends UxAbstractSchemaLifeCycleQuery {
    private final String schemaName;
    private final int waitS;
    private final int cancelS;

    protected UxUnloadSchemaQuery(UxQueryMeta meta, OlapRequestId requestId, String schemaName, int waitS, int cancelS) {
        super(meta, requestId, (Integer)null);
        this.schemaName = schemaName;
        this.waitS = waitS;
        this.cancelS = cancelS;
    }

    @Override
    public boolean isMonitoredForTimeout() {
        return false;
    }

    @Override
    @Nullable
    public String getSchemaLifeCycleName() {
        return this.schemaName;
    }

    @Override
    @Nullable
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public IcCubeSchemaAccessLockMode getSchemaAccessLockMode() {
        return IcCubeSchemaAccessLockMode.WRITE;
    }

    @Override
    public boolean isUnloadSchema() {
        return true;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        OlapEngineRequestContext engineContext = queryContext.getOlapEngineRequestContext();
        OlapLoadSchemaHelper helper = new OlapLoadSchemaHelper(engineContext);
        boolean unloaded = helper.unloadSchema(this.schemaName, this.waitS, this.cancelS);
        return UxReply.actionSuccess(new UxSchemaLifeCycleStatus(this.schemaName, unloaded ? OlapSchemaLoadStatus.UNLOADED : OlapSchemaLoadStatus.NOP));
    }
}

