/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema.lifecycle;

import crazydev.iccube.ux.admin.queries.schema.UxAbstractSchemaQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.UxSchemaFactoryFile;
import crazydev.iccube.ux.admin.queries.schema.backup.UxBackupsQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.lifecycle.UxRestoreBackupQuery;
import crazydev.iccube.ux.admin.queries.schema.lifecycle.UxRestoreMode;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.action.UxActionBuilder;
import crazydev.iccube.ux.common.field.UxField;
import crazydev.iccube.ux.common.field.UxFieldMeta;
import crazydev.iccube.ux.common.field.UxFieldTypes;
import crazydev.iccube.ux.common.field.UxFieldValue;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.common.url.UxUrl;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import org.jetbrains.annotations.Nullable;

public class UxRestoreBackupQueryMeta
extends UxAbstractSchemaQueryMeta {
    public static final UxRestoreBackupQueryMeta RestoreBackup = new UxRestoreBackupQueryMeta();

    private UxRestoreBackupQueryMeta() {
        super(UxConsoleConstants.QueryName.RestoreBackup);
    }

    @Override
    public boolean isAuthorized(UxQueryContext context) {
        return UxBackupsQueryMeta.Backups.isAuthorized(context);
    }

    @Override
    public UxQuery parseQuery(UxServerRequestParams params) throws UxQueryParserException {
        Integer timeoutS = params.getIntegerParameter("timeoutS");
        String schema = params.getExistingStringParameter("schemaName");
        String timestamp = params.getExistingStringParameter("timestamp");
        UxRestoreMode mode = params.getExistingEnumParameter(UxRestoreMode.class, "mode");
        boolean backupOff = params.getBooleanParameter("backupOff");
        int waitS = params.getIntegerParameter("waitS", -1);
        int cancelS = params.getIntegerParameter("cancelS", -1);
        return new UxRestoreBackupQuery(this, params.getRequestId(), timeoutS, schema, timestamp, mode, backupOff, waitS, cancelS);
    }

    public UxUrl createQueryUrl(String schema, String timestamp) {
        return this.createQueryUrl().addParam("schemaName", schema).addParam("timestamp", timestamp);
    }

    @Nullable
    public static UxAction createAction(UxQueryContext context, String schema, String timestamp, UxSchemaFactoryFile factoryFile) {
        UxBabylonService babylon = context.getUxBabylonService();
        UxUrl url = RestoreBackup.createQueryUrl(schema, timestamp);
        return new UxActionBuilder(context, RestoreBackup).withUrl(url).withParams(new UxField(babylon, "mode", new UxFieldMeta(UxFieldTypes.ENUM(babylon, UxRestoreMode.class), true, false, true), new UxFieldValue(UxRestoreMode.FULL.name())), new UxField(babylon, "backupOff", new UxFieldMeta(UxFieldTypes.BOOLEAN, true, false, false), new UxFieldValue(true))).withProgressInfo(UxRestoreBackupQueryMeta.createProgressInfoAction(context), UxRestoreBackupQueryMeta.createProgressInfoActionRefreshS(context), UxRestoreBackupQueryMeta.createProgressContinuationAction(context)).build();
    }
}

