/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema.lifecycle;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.command.builtin.OlapEngineRestoreSchemaParams;
import crazydev.iccube.olap.component.command.builtin.OlapRestoreSchemaHelper;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLifeCycleStatus;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.schema.OlapSchemaInformation;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.UxActionResult;
import crazydev.iccube.ux.admin.queries.schema.UxExtendedErrors;
import crazydev.iccube.ux.admin.queries.schema.UxSchemaInfoQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.lifecycle.UxAbstractSchemaLifeCycleQuery;
import crazydev.iccube.ux.admin.queries.schema.lifecycle.UxRestoreMode;
import crazydev.iccube.ux.admin.queries.schema.lifecycle.UxSchemaLifeCycleStatus;
import crazydev.iccube.ux.common.action.UxActionContinuation;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryKind;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.processor.UxServerRequestContext;
import java.io.File;
import org.jetbrains.annotations.Nullable;

public class UxRestoreBackupQuery
extends UxAbstractSchemaLifeCycleQuery {
    private final String schemaName;
    private final String timestamp;
    private final UxRestoreMode mode;
    private final boolean backupOff;
    private final int waitS;
    private final int cancelS;

    protected UxRestoreBackupQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable Integer timeoutS, String schemaName, String timestamp, UxRestoreMode mode, boolean backupOff, int waitS, int cancelS) {
        super(meta, requestId, timeoutS);
        this.schemaName = schemaName;
        this.timestamp = timestamp;
        this.mode = mode;
        this.backupOff = backupOff;
        this.waitS = waitS;
        this.cancelS = cancelS;
    }

    @Override
    public UxQueryKind getKind() {
        return UxQueryKind.LOAD;
    }

    @Override
    @Nullable
    public String getSchemaLifeCycleName() {
        return this.schemaName;
    }

    @Override
    @Nullable
    public OlapFile getSchemaFactoryFileName(UxServerRequestContext context) {
        if (CdStringUtils.isNotNullAndNotBlank((String)this.schemaName) && CdStringUtils.isNotNullAndNotBlank((String)this.timestamp)) {
            return context.createSchemaFactoryFileFromBackup(this.schemaName, this.timestamp);
        }
        return null;
    }

    @Override
    public boolean isLoadSchema() {
        return true;
    }

    @Override
    public boolean isFullLoadSchema() {
        return true;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        UxUseCase loadedSchemaUC;
        OlapRuntimeContext rContext;
        OlapEngineComponent engine;
        OlapSchemaInformation loadedSchema;
        OlapEngineRequestContext engineContext = queryContext.getOlapEngineRequestContext();
        OlapRestoreSchemaHelper helper = new OlapRestoreSchemaHelper(engineContext);
        OlapFile schemaFactoryFileFromBackup = queryContext.createSchemaFactoryFileFromBackup(this.schemaName, this.timestamp);
        File schemaFactoryFile = schemaFactoryFileFromBackup.__getUnderlying();
        OlapEngineRestoreSchemaParams params = new OlapEngineRestoreSchemaParams(engineContext.isInCluster(), "n/a", schemaFactoryFile, this.schemaName, this.timestamp, UxRestoreMode.asBackupMode(this.mode).name(), this.backupOff, this.waitS, this.cancelS);
        OlapSchemaLifeCycleStatus status = helper.restoreSchema(params);
        UxExtendedErrors errors = new UxExtendedErrors();
        if (status.isError()) {
            errors = UxRestoreBackupQuery.getErrorForActiveRequest(queryContext, status.getSchema(), schemaFactoryFile, "sch_restoreBackupError");
        }
        UxSchemaLifeCycleStatus result = new UxSchemaLifeCycleStatus(status.getSchema(), status.getLoadStatus(), null, errors.errors, errors.vMessage, errors.vMessages);
        UxActionContinuation continuation = null;
        if (!status.isError() && (loadedSchema = (engine = queryContext.getOlapEngineComponent()).getLoadedSchemaInformation(rContext = queryContext.asRuntimeContext(), this.schemaName)) != null && (loadedSchemaUC = UxSchemaInfoQueryMeta.createUseCaseForLoadedUnloaded(queryContext, loadedSchema, null, null)) != null) {
            continuation = new UxActionContinuation(UxActionContinuationKind.NAVIGATE, loadedSchemaUC);
        }
        return UxReply.actionSuccess((UxActionResult)result, continuation);
    }
}

