/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema.lifecycle;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.command.builtin.IOlapEngineLoadSchemaParams;
import crazydev.iccube.olap.component.command.builtin.OlapEngineLoadSchemaParams;
import crazydev.iccube.olap.component.command.builtin.OlapEngineOfflineMode;
import crazydev.iccube.olap.component.command.builtin.OlapLoadSchemaHelper;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaIncrLoadStatus;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLifeCycleStatus;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.schema.OlapSchemaInformation;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.UxActionResult;
import crazydev.iccube.ux.admin.queries.schema.UxExtendedErrors;
import crazydev.iccube.ux.admin.queries.schema.UxSchemaInfoQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.lifecycle.UxAbstractSchemaLifeCycleQuery;
import crazydev.iccube.ux.admin.queries.schema.lifecycle.UxSchemaLifeCycleStatus;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.action.UxActionBuilder;
import crazydev.iccube.ux.common.action.UxActionContinuation;
import crazydev.iccube.ux.common.action.UxActionNavigateContinuation;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryExpectedException;
import crazydev.iccube.ux.common.query.UxQueryKind;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.url.UxUrl;
import crazydev.iccube.ux.common.url.UxUrlConstants;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.mdx.queries.init.UxMdxConsoleHomeQueryMeta;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxServerRequestContext;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class UxLoadSchemaQuery
extends UxAbstractSchemaLifeCycleQuery {
    private final UxSchemaId schemaId;
    private final boolean incrLoad;
    private final boolean keepMdxResultCache;
    private final boolean forceBackup;
    private final int waitS;
    private final int cancelS;
    @Nullable
    private String schemaFile;
    @Nullable
    private String schemaName;

    protected UxLoadSchemaQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable Integer timeoutS, UxSchemaId schemaId, boolean incrLoad, boolean keepMdxResultCache, boolean forceBackup, int waitS, int cancelS) {
        super(meta, requestId, timeoutS);
        this.schemaId = schemaId;
        this.incrLoad = incrLoad;
        this.keepMdxResultCache = keepMdxResultCache;
        this.forceBackup = forceBackup;
        this.waitS = waitS;
        this.cancelS = cancelS;
    }

    @Override
    public UxQueryKind getKind() {
        return UxQueryKind.LOAD;
    }

    @Override
    public void initialize(UxServerRequestContext requestContext) {
        super.initialize(requestContext);
        if (CdStringUtils.isNotNullAndNotBlank((String)this.schemaId.schemaFile)) {
            this.schemaName = this.schemaId.schemaName;
            this.schemaFile = this.schemaId.schemaFile;
        } else {
            this.schemaName = this.schemaId.schemaName;
            this.schemaFile = requestContext.resolveFactoryFileFromSchemaName(this.schemaId.schemaName);
            if (this.schemaFile == null) {
                throw new UxQueryExpectedException(UxErrorCode.SCHEMA_FILE_UNRESOLVED, new Serializable[]{this.schemaId.schemaName});
            }
        }
    }

    @Override
    public String getSchemaLifeCycleName() {
        return CdStringUtils.isNotNullAndNotBlank((String)this.schemaName) ? this.schemaName : this.schemaFile;
    }

    @Override
    public OlapFile getSchemaFactoryFileName(UxServerRequestContext context) {
        if (CdStringUtils.isNotNullAndNotBlank((String)this.schemaFile)) {
            return context.createSchemaFactoryFile(false, this.schemaFile);
        }
        return null;
    }

    @Override
    public boolean isLoadSchema() {
        return true;
    }

    @Override
    public boolean isFullLoadSchema() {
        return !this.incrLoad;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        UxUseCase loadedSchemaUC;
        if (CdStringUtils.isNullOrBlank((String)this.schemaFile)) {
            throw new RuntimeException("internal error: missing schemaFile");
        }
        OlapEngineRequestContext engineContext = queryContext.getOlapEngineRequestContext();
        OlapLoadSchemaHelper helper = new OlapLoadSchemaHelper(engineContext);
        File schemaFactoryFile = queryContext.createSchemaFactoryFile(false, this.schemaFile).__getUnderlying();
        OlapEngineLoadSchemaParams params = this.incrLoad ? new OlapEngineLoadSchemaParams(schemaFactoryFile, false, this.waitS, this.cancelS, OlapEngineOfflineMode.OFF, null, false, this.keepMdxResultCache) : new OlapEngineLoadSchemaParams(schemaFactoryFile, true, this.waitS, this.cancelS, OlapEngineOfflineMode.OFF, null, this.forceBackup);
        OlapSchemaLifeCycleStatus status = helper.loadSchema((IOlapEngineLoadSchemaParams)params);
        OlapEngineComponent engine = queryContext.getOlapEngineComponent();
        OlapRuntimeContext rContext = queryContext.asRuntimeContext();
        OlapSchemaInformation info = engine.getLoadedSchemaInformation(rContext, schemaFactoryFile);
        String extra = null;
        if (info != null) {
            extra = info.getBackupStatus();
        }
        UxExtendedErrors errors = new UxExtendedErrors();
        if (status.isError()) {
            errors = UxLoadSchemaQuery.getErrorForActiveRequest(queryContext, status.getSchema(), schemaFactoryFile, "sch_loadError");
        }
        UxActionContinuation continuation = null;
        if (!status.isError() && info != null && (loadedSchemaUC = UxSchemaInfoQueryMeta.createUseCaseForLoadedUnloaded(queryContext, info, null, null)) != null) {
            continuation = UxLoadSchemaQuery.setupContinuation(queryContext, info.getName(), loadedSchemaUC);
        }
        OlapSchemaIncrLoadStatus incrLoadStatus = null;
        if (this.incrLoad && info != null && info.isIncremental()) {
            incrLoadStatus = info.isIncrLoadDeActivatedOnError() ? OlapSchemaIncrLoadStatus.DEACTIVATED : OlapSchemaIncrLoadStatus.OK;
        }
        UxSchemaLifeCycleStatus result = new UxSchemaLifeCycleStatus(status.getSchema(), status.getLoadStatus(), incrLoadStatus, extra, errors.errors, errors.vMessage, errors.vMessages);
        return UxReply.actionSuccess((UxActionResult)result, continuation);
    }

    private static UxActionContinuation setupContinuation(UxQueryContext context, String schemaName, UxUseCase loadedSchemaUC) {
        UxUrl mdxURL;
        UxAction mdx;
        ArrayList<UxAction> actions = new ArrayList<UxAction>();
        UxAction action = new UxActionBuilder(context, UxSchemaInfoQueryMeta.SchemaInfo).withId("SchemaDefLoadedMonitoring").withUseCase(loadedSchemaUC).build();
        if (action != null) {
            actions.add(action);
        }
        if ((mdx = new UxActionBuilder(context, UxMdxConsoleHomeQueryMeta.MdxConsoleHome).withUrl(mdxURL = UxUrlConstants.APP_URL_MDX.addParam("schema", schemaName)).withContinuation(UxActionContinuationKind.OPEN_INTERNAL).build()) != null) {
            actions.add(mdx);
        }
        UxBabylonService babylon = context.getUxBabylonService();
        String synopsis = babylon.translate("schemaDefLoadedSuccessfully", new Serializable[]{schemaName});
        return new UxActionNavigateContinuation(synopsis, actions);
    }
}

