/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema.backup;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.cluster.master.backup.save.M_BackupManager;
import crazydev.iccube.cluster.master.backup.save.M_DeleteBackupInfo;
import crazydev.iccube.cluster.master.backup.save.M_DeleteBackupInfos;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.schema.UxAbstractSchemaQuery;
import crazydev.iccube.ux.common.action.UxActionPerformed;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxDeleteBackupsQuery
extends UxAbstractSchemaQuery {
    @Nullable
    private final String schemaName;

    protected UxDeleteBackupsQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String schemaName) {
        super(meta, requestId);
        this.schemaName = schemaName;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        if (CdStringUtils.isNullOrBlank((String)this.schemaName)) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.BACKUP_MISSING, (Serializable[])new Serializable[0]));
        }
        M_BackupManager backupManager = queryContext.getBackupManager();
        M_DeleteBackupInfos deleted = backupManager.deleteBackups(this.schemaName, "cleanup");
        StringBuilder backupsDeleteMessage = new StringBuilder();
        boolean backupsDeleted = false;
        for (M_DeleteBackupInfo info : deleted.getInfos()) {
            OlapLoggers.UX_REQUEST.debug((Object)("[UX] schema backup deleted [" + this.schemaName + "] [" + info.getTimestamp() + "]"));
            if (!info.isDeleted()) continue;
            backupsDeleted = true;
            if (backupsDeleteMessage.length() > 0) {
                backupsDeleteMessage.append("|");
            }
            backupsDeleteMessage.append(info.getTimestamp());
        }
        return UxReply.actionSuccess(new UxActionPerformed(backupsDeleted, backupsDeleteMessage.toString()));
    }
}

