/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema.backup;

import crazydev.iccube.ux.admin.queries.schema.UxAbstractSchemaQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.backup.UxBackupsQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.backup.UxDeleteBackupQuery;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.action.UxActionBuilder;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.common.url.UxUrl;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import org.jetbrains.annotations.Nullable;

public class UxDeleteBackupQueryMeta
extends UxAbstractSchemaQueryMeta {
    public static final UxDeleteBackupQueryMeta DeleteBackup = new UxDeleteBackupQueryMeta();

    private UxDeleteBackupQueryMeta() {
        super(UxConsoleConstants.QueryName.DeleteBackup);
    }

    @Override
    public boolean isAuthorized(UxQueryContext context) {
        return UxBackupsQueryMeta.Backups.isAuthorized(context);
    }

    @Override
    public UxQuery parseQuery(UxServerRequestParams params) throws UxQueryParserException {
        String schema = params.getStringParameter("schemaName");
        String timestamp = params.getStringParameter("timestamp");
        return new UxDeleteBackupQuery(this, params.getRequestId(), schema, timestamp);
    }

    public UxUrl createQueryUrl(String schema, String timestamp) {
        return this.createQueryUrl().addParam("schemaName", schema).addParam("timestamp", timestamp);
    }

    @Nullable
    public static UxAction createAction(UxQueryContext context, String schema, String timestamp) {
        UxUrl url = DeleteBackup.createQueryUrl(schema, timestamp);
        String name = schema + " : " + timestamp;
        return new UxActionBuilder(context, DeleteBackup).withOkCancelWithParam(name).withContinuation(context.getUseCase(UxAdminUseCaseName.Backups)).withUrl(url).build();
    }
}

