/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema.backup;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.cluster.master.backup.save.M_BackupManager;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.schema.UxAbstractSchemaQuery;
import crazydev.iccube.ux.common.action.UxActionPerformed;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxDeleteBackupQuery
extends UxAbstractSchemaQuery {
    @Nullable
    private final String schemaName;
    @Nullable
    private final String timestamp;

    protected UxDeleteBackupQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String schemaName, @Nullable String timestamp) {
        super(meta, requestId);
        this.schemaName = schemaName;
        this.timestamp = timestamp;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        if (CdStringUtils.isNullOrBlank((String)this.schemaName) || CdStringUtils.isNullOrBlank((String)this.timestamp)) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.BACKUP_MISSING, (Serializable[])new Serializable[0]));
        }
        M_BackupManager backupManager = queryContext.getBackupManager();
        boolean deleted = backupManager.deleteBackup(this.schemaName, this.timestamp);
        OlapLoggers.UX_REQUEST.debug((Object)("[UX] schema backup deleted [" + this.schemaName + "] [" + this.timestamp + "] [" + deleted + "]"));
        return UxReply.actionSuccess(new UxActionPerformed(deleted));
    }
}

