/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema.backup;

import crazydev.iccube.ux.admin.queries.schema.UxAbstractSchemaQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.backup.UxBackupsQuery;
import crazydev.iccube.ux.admin.queries.schema.backup.UxCleanAllBackupsQueryMeta;
import crazydev.iccube.ux.admin.queries.utils.UxArrays;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.file.UxFileUploadCardinality;
import crazydev.iccube.ux.common.file.UxFileUploadMeta;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.console.queries.refresh.UxRefreshQueryMeta;
import crazydev.iccube.ux.console.queries.upload.UxFileType;
import crazydev.iccube.ux.console.queries.upload.UxUploadFileQueryMeta;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxBackupsQueryMeta
extends UxAbstractSchemaQueryMeta {
    public static final UxBackupsQueryMeta Backups = new UxBackupsQueryMeta();

    private UxBackupsQueryMeta() {
        super(UxConsoleConstants.QueryName.Backups);
    }

    @Override
    public boolean isAuthorized(UxQueryContext context) {
        return super.isAuthorized(context) && context.isBackupLicensed();
    }

    @Override
    public List<UxAction> createActions(UxQueryContext context) {
        return UxArrays.asList(UxRefreshQueryMeta.createAction(context), UxUploadFileQueryMeta.createActionForBackup(context), UxCleanAllBackupsQueryMeta.createAction(context));
    }

    @Override
    @Nullable
    public UxFileUploadMeta createFileUpload(UxQueryContext context) {
        if (!this.isAuthorized(context) || !UxUploadFileQueryMeta.UploadFile.isAuthorized(context)) {
            return null;
        }
        return new UxFileUploadMeta(UxFileUploadCardinality.MULTI, UxFileType.SCHEMA_BACKUP, "zip");
    }

    @Override
    public UxQuery parseQuery(UxServerRequestParams params) throws UxQueryParserException {
        UxTableOptions tableOptions = params.getTableOptions();
        return new UxBackupsQuery(this, params.getRequestId(), tableOptions);
    }
}

