/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema.backup;

import crazydev.iccube.cluster.master.backup.info.M_BackupInfoUI;
import crazydev.iccube.cluster.master.backup.save.M_BackupManager;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.schema.UxAbstractSchemaQuery;
import crazydev.iccube.ux.admin.queries.schema.UxSchemaFactoryFile;
import crazydev.iccube.ux.admin.queries.schema.backup.UxBackupInfo;
import crazydev.iccube.ux.admin.queries.schema.backup.UxBackupInfoQueryMeta;
import crazydev.iccube.ux.admin.queries.utils.UxRowFilters;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.common.filter.UxFilterMeta;
import crazydev.iccube.ux.common.filter.UxFilterMetas;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.style.UxStyleLevel;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableCell;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableMeta;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.common.table.UxTableRowSearcher;
import crazydev.iccube.ux.common.table.UxTableSearcher;
import crazydev.iccube.ux.common.table.UxTableWithUseCasesReplyPayload;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class UxBackupsQuery
extends UxAbstractSchemaQuery {
    protected UxBackupsQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxTableOptions tableOptions) {
        super(meta, requestId, tableOptions);
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        UxBabylonService babylon = queryContext.getUxBabylonService();
        UxTableHeaders header = UxTableHeaders.create(babylon, "group", "schema", "backupTimestamp", "backupStatus");
        UxFilterMetas filterMetas = new UxFilterMetas(new UxFilterMeta<UxBackupInfo>("group", babylon.translate("filterSchemaGroup", new Serializable[0]), UxBackupInfo::getSchemaGroup), new UxFilterMeta<UxBackupInfo>("schema", babylon.translate("filterSchemaName", new Serializable[0]), UxBackupInfo::getSchema));
        UxTableSearcher rowSearcher = this.setupRowSearcher(this.tableOptions, new UxTableRowSearcher<UxBackupInfo>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public boolean isAccepting(UxBackupInfo row, String searchText) {
                return this.isContaining(searchText, row.getSchema(), row.getSchemaGroup());
            }
        });
        UxRowFilters rowFilters = this.setupRowFilters(this.tableOptions, filterMetas);
        M_BackupManager backupManager = queryContext.getBackupManager();
        ArrayList backups = new ArrayList();
        backupManager.forEachBackupInfoUI(backup -> {
            UxBackupInfo backup_ = new UxBackupInfo((M_BackupInfoUI)backup);
            if ((rowSearcher == null || rowSearcher.isAccepting(backup_)) && (rowFilters == null || rowFilters.isAccepting(backup_))) {
                backups.add(backup_);
            }
        });
        backups.sort((o1, o2) -> {
            String n2;
            String g2;
            String g1 = o1.getSchemaGroup() != null ? o1.getSchemaGroup() : "";
            int cmp = g1.compareTo(g2 = o2.getSchemaGroup() != null ? o2.getSchemaGroup() : "");
            if (cmp != 0) {
                return cmp;
            }
            String n1 = o1.getSchema();
            cmp = n1.compareTo(n2 = o2.getSchema());
            if (cmp != 0) {
                return cmp;
            }
            String t1 = o1.getTimestampSortable();
            String t2 = o2.getTimestampSortable();
            return -t1.compareTo(t2);
        });
        int totalRowCount = backups.size();
        UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.createForFirstPageWithDefaults(queryContext.getApi(), totalRowCount));
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        for (UxBackupInfo backup2 : backups) {
            rows.add(UxBackupsQuery.createRow(queryContext, backup2));
        }
        UxTable table = UxTable.create(options, header, rows);
        List<UxTableRow> actualRows = table.getRows();
        if (actualRows != null) {
            for (UxTableRow actualRow : actualRows) {
                UxBackupsQuery.setupRowUseCase(queryContext, actualRow);
            }
        }
        UxTableMeta tableMeta = new UxTableMeta(true, filterMetas);
        return UxReply.success(new UxTableWithUseCasesReplyPayload(tableMeta, table));
    }

    private static UxTableRow createRow(UxQueryContext context, UxBackupInfo backup) {
        UxStyleLevel styleLevel;
        Object backupStatus;
        UxBabylonService babylon = context.getUxBabylonService();
        boolean isForRestApi = context.isForRestApi();
        UxUseCase useCase = null;
        if (backup.isValid()) {
            int count = backup.getActivityCount();
            if (count == 0) {
                backupStatus = !isForRestApi ? babylon.translate("backupStatusValid", new Serializable[0]) : "OK";
                styleLevel = UxStyleLevel.INFO;
            } else {
                backupStatus = !isForRestApi ? babylon.translate("backupStatusValidX", Integer.valueOf(count)) : "OK:" + count;
                styleLevel = UxStyleLevel.INFO;
            }
        } else if (!backup.isInitialLoadValid()) {
            backupStatus = !isForRestApi ? babylon.translate("backupStatusInvalidInitialLoad", new Serializable[0]) : "ERROR";
            styleLevel = UxStyleLevel.ERROR;
        } else {
            backupStatus = !isForRestApi ? babylon.translate("backupStatusInvalidActivity", Integer.valueOf(backup.getActivityCount())) : "ERROR:" + backup.getActivityCount();
            styleLevel = UxStyleLevel.ERROR;
        }
        ArrayList<UxTableCell> cells = new ArrayList<UxTableCell>();
        cells.add(new UxTableCell(backup.getSchemaGroup()));
        cells.add(new UxTableCell(backup.getSchema()));
        cells.add(new UxTableCell((Object)backup.getTimestampSortable(), useCase));
        cells.add(new UxTableCell(backupStatus));
        UxTableRow row = new UxTableRow(cells).withStyle(styleLevel);
        row.setData(backup);
        return row;
    }

    private static void setupRowUseCase(UxQueryContext context, UxTableRow row) {
        UxBackupInfo backup = (UxBackupInfo)row.getData();
        UxUseCase useCase = UxBackupInfoQueryMeta.createUseCase(context, backup.getSchema(), backup.getTimestamp(), UxSchemaFactoryFile.fromFile(context, false, backup.getFactoryFile()));
        row.setUseCase(useCase);
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxAdminUseCaseName.Backups));
    }
}

