/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema.backup;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.utils.CdSizeUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.cluster.master.backup.info.M_BackupDetailUI;
import crazydev.iccube.cluster.master.backup.save.M_BackupManager;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.schema.UxAbstractSchemaQuery;
import crazydev.iccube.ux.admin.queries.schema.UxSchemaFactoryFile;
import crazydev.iccube.ux.admin.queries.schema.backup.UxBackupInfo;
import crazydev.iccube.ux.admin.queries.schema.backup.UxBackupInfoQueryMeta;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.style.UxStyleLevel;
import crazydev.iccube.ux.common.table.UxPropertyTableReplyPayload;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class UxBackupInfoQuery
extends UxAbstractSchemaQuery {
    @Nullable
    private final String schemaName;
    @Nullable
    private final String timestamp;
    @Nullable
    private M_BackupDetailUI backup;

    protected UxBackupInfoQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String schemaName, @Nullable String timestamp, @Nullable UxTableOptions tableOptions) {
        super(meta, requestId, tableOptions);
        this.schemaName = schemaName;
        this.timestamp = timestamp;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        UxBabylonService babylon = queryContext.getUxBabylonService();
        if (CdStringUtils.isNotNullAndNotBlank((String)this.schemaName) && CdStringUtils.isNotNullAndNotBlank((String)this.timestamp)) {
            M_BackupManager backupManager = queryContext.getBackupManager();
            this.backup = backupManager.getBackupDetailUI(this.schemaName, this.timestamp);
        }
        if (this.backup == null) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.BACKUP_UNKNOWN, (Serializable[])new Serializable[]{this.schemaName, this.timestamp}));
        }
        UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.create());
        UxTableHeaders header = UxTableHeaders.create(babylon, "property", "value");
        List<UxTableRow> rows = this.setupRows(queryContext, this.backup);
        UxTable table = UxTable.create(options, header, rows);
        return UxReply.success(new UxPropertyTableReplyPayload(table));
    }

    private List<UxTableRow> setupRows(UxQueryContext queryContext, M_BackupDetailUI backup) {
        String activities;
        UxStyleLevel backupStatusStyle;
        Object backupStatus;
        UxBabylonService babylon = queryContext.getUxBabylonService();
        boolean isForRestApi = queryContext.isForRestApi();
        UxBackupInfo info = new UxBackupInfo(backup.getBackup());
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "schema"), info.getSchema()));
        rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "group"), info.getSchemaGroup()));
        rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "backupTimestamp"), info.getTimestampSortable()));
        if (info.isValid()) {
            int count = info.getActivityCount();
            if (count == 0) {
                backupStatus = !isForRestApi ? babylon.translate("backupStatusValid", new Serializable[0]) : "OK";
                backupStatusStyle = UxStyleLevel.INFO;
            } else {
                backupStatus = !isForRestApi ? babylon.translate("backupStatusValidX", Integer.valueOf(count)) : "OK:" + count;
                backupStatusStyle = UxStyleLevel.INFO;
            }
        } else if (!info.isInitialLoadValid()) {
            backupStatus = !isForRestApi ? babylon.translate("backupStatusInvalidInitialLoad", new Serializable[0]) : "ERROR";
            backupStatusStyle = UxStyleLevel.ERROR;
        } else {
            backupStatus = !isForRestApi ? babylon.translate("backupStatusInvalidActivity", Integer.valueOf(info.getActivityCount())) : "ERROR:" + info.getActivityCount();
            backupStatusStyle = UxStyleLevel.ERROR;
        }
        rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "backupStatus"), (String)backupStatus).withStyle(backupStatusStyle));
        String size = CdSizeUtils.format((Locale)babylon.getLocale(), (double)backup.getSize());
        rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "backupSize"), size));
        if (CdStringUtils.isNotNullAndNotBlank((String)backup.getErrors())) {
            rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "backupErrors"), backup.getErrors()).withStyle(UxStyleLevel.ERROR));
        }
        if (CdStringUtils.isNotNullAndNotBlank((String)(activities = backup.getLastActivities(25)))) {
            rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "backupLatestActivities"), activities));
        }
        return rows;
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        File factory = this.backup != null ? this.backup.getFactoryFile() : null;
        UxSchemaFactoryFile factoryFile = factory != null ? UxSchemaFactoryFile.fromFile(queryContext, false, factory) : null;
        reply.withUseCase(UxBackupInfoQueryMeta.createUseCase(queryContext, this.schemaName, this.timestamp, factoryFile));
    }
}

