/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema;

import crazydev.iccube.ux.admin.queries.schema.UxAbstractSchemaQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.UxDownloadSchemaStatsFileQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.UxSchemaStatsFileQuery;
import crazydev.iccube.ux.admin.queries.utils.UxArrays;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.action.UxActionBuilder;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.url.UxUrl;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.usecase.UxUseCaseBuilder;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.console.queries.refresh.UxRefreshQueryMeta;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxSchemaStatsFileQueryMeta
extends UxAbstractSchemaQueryMeta {
    public static final UxSchemaStatsFileQueryMeta SchemaStatsFile = new UxSchemaStatsFileQueryMeta();

    public UxSchemaStatsFileQueryMeta() {
        super(UxConsoleConstants.QueryName.SchemaStatsFile);
    }

    @Override
    public List<UxAction> createActions(UxQueryContext context) {
        return UxArrays.asList(UxRefreshQueryMeta.createAction(context));
    }

    @Override
    public UxQuery parseQuery(UxServerRequestParams params) {
        String schemaName = params.getStringParameter("schemaName");
        return new UxSchemaStatsFileQuery((UxQueryMeta)this, params.getRequestId(), schemaName);
    }

    public UxUrl createQueryUrl(String schemaName) {
        return this.createQueryUrl().addParam("schemaName", schemaName);
    }

    @Nullable
    public static UxAction createAction(UxQueryContext context, String schemaName) {
        UxUseCase useCase = UxSchemaStatsFileQueryMeta.createUseCase(context, schemaName);
        return new UxActionBuilder(context, SchemaStatsFile).withUseCase(useCase).build();
    }

    static UxUseCase createUseCase(UxQueryContext context, @Nullable String schemaName) {
        List<UxAction> actions = null;
        if (schemaName != null) {
            actions = SchemaStatsFile.createActions(context);
            actions.add(UxDownloadSchemaStatsFileQueryMeta.createAction(context, schemaName));
        }
        UxBabylonService babylon = context.getUxBabylonService();
        return new UxUseCaseBuilder(context, SchemaStatsFile).withId(UxAdminUseCaseName.SchemaStatsFile.name() + "-" + schemaName).withCaption(babylon.translateUseCaseCaption(UxAdminUseCaseName.SchemaStatsFile.name(), new Serializable[]{schemaName})).withUrl(SchemaStatsFile.createQueryUrl(schemaName)).withActions(actions).build(true);
    }
}

