/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema;

import crazydev.iccube.olap.schema.OlapSchemaInformation;
import crazydev.iccube.request.status.IcCubeRequestStatus;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.ux.admin.queries.runtime.request.UxCancelRequestQueryMeta;
import crazydev.iccube.ux.admin.queries.runtime.request.UxRequestQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.UxAbstractSchemaQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.UxDeleteSchemaFileQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.UxDownloadSchemaFileQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.UxDownloadSchemaStatsFileQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.UxRefreshSchemaStatsQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.UxSchemaFactoryFile;
import crazydev.iccube.ux.admin.queries.schema.UxSchemaFileQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.UxSchemaInfoQuery;
import crazydev.iccube.ux.admin.queries.schema.UxSchemaStatsFileQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.lifecycle.UxLoadSchemaCreateOfflineQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.lifecycle.UxLoadSchemaQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.lifecycle.UxSchemaCreateOfflineQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.lifecycle.UxUnloadSchemaQueryMeta;
import crazydev.iccube.ux.admin.queries.utils.UxArrays;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseRepository;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.url.UxUrl;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.usecase.UxUseCaseBuilder;
import crazydev.iccube.ux.common.usecase.UxUseCaseTitle;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.console.queries.refresh.UxRefreshQueryMeta;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxSchemaInfoQueryMeta
extends UxAbstractSchemaQueryMeta {
    public static final UxSchemaInfoQueryMeta SchemaInfo = new UxSchemaInfoQueryMeta();

    public UxSchemaInfoQueryMeta() {
        super(UxConsoleConstants.QueryName.SchemaInfo);
    }

    @Override
    public List<UxAction> createActions(UxQueryContext context) {
        return UxArrays.asList(UxRefreshQueryMeta.createAction(context));
    }

    @Override
    public UxQuery parseQuery(UxServerRequestParams params) throws UxQueryParserException {
        UxSchemaId schemaId = params.getExistingSchemaIdParameter();
        UxTableOptions tableOptions = params.getTableOptions();
        return new UxSchemaInfoQuery(this, params.getRequestId(), schemaId, tableOptions);
    }

    public UxUrl createQueryUrl(@Nullable UxSchemaId schemaId) {
        if (schemaId == null) {
            return this.createQueryUrl();
        }
        return this.createQueryUrl().addParam(schemaId);
    }

    public static UxUseCase createUseCaseForLoadedUnloaded(UxQueryContext context, @Nullable OlapSchemaInformation loadedSchema, @Nullable String unloadedSchema, @Nullable UxSchemaFactoryFile factoryFileName) {
        String schemaPath;
        UxBabylonService babylon = context.getUxBabylonService();
        if (loadedSchema != null) {
            factoryFileName = UxSchemaFactoryFile.fromFile(context, false, loadedSchema.getFactoryFile());
        }
        List<UxAction> actions = null;
        if (loadedSchema != null) {
            actions = UxSchemaInfoQueryMeta.createUseCaseActionsForLoadedSchema(context, loadedSchema, factoryFileName);
        } else if (factoryFileName != null) {
            actions = UxSchemaInfoQueryMeta.createUseCaseActionsForUnloadedSchema(context, factoryFileName);
        }
        String string = schemaPath = factoryFileName != null ? factoryFileName.relativePath() : null;
        String schemaName = loadedSchema != null ? loadedSchema.getName() : (unloadedSchema != null ? unloadedSchema : schemaPath);
        UxAdminUseCaseName pUseCaseName = loadedSchema != null ? UxAdminUseCaseName.LoadedSchemas : UxAdminUseCaseName.UnloadedSchemas;
        UxSchemaId schemaId = new UxSchemaId(schemaName, schemaPath);
        return new UxUseCaseBuilder(context, SchemaInfo).withId(UxAdminUseCaseName.SchemaInfo.name() + "-" + schemaPath).withCaption(babylon.translateUseCaseCaption(UxAdminUseCaseName.SchemaInfo.name(), new Serializable[0])).withUrl(SchemaInfo.createQueryUrl(schemaId)).withExtraTitle(new UxUseCaseTitle(context.getUseCase(pUseCaseName), schemaName, UxAdminUseCaseRepository.asBookmark(SchemaInfo.createQueryUrl(schemaId)))).withActions(actions).build(true);
    }

    private static List<UxAction> createUseCaseActionsForLoadedSchema(UxQueryContext context, OlapSchemaInformation loadedSchema, UxSchemaFactoryFile factoryFileName) {
        UxBabylonService babylon = context.getUxBabylonService();
        List<UxAction> actions = SchemaInfo.createActions(context);
        actions.add(UxLoadSchemaQueryMeta.createFullReloadAction(context, factoryFileName.relativePath()));
        if (loadedSchema.isIncremental()) {
            actions.add(UxLoadSchemaQueryMeta.createIncrLoadAction(context, factoryFileName.relativePath()));
        }
        actions.add(UxUnloadSchemaQueryMeta.createAction(context, loadedSchema.getName()));
        String requestUuid = loadedSchema.getRequestUuid();
        IcCubeRequestStatusManager manager = context.getRequestStatusManager();
        IcCubeRequestStatus request = manager.getRequestStatus(requestUuid);
        if (request != null) {
            actions.add(UxRequestQueryMeta.createAction(context, babylon.translateActionCaption("LoadingRequest", new Serializable[0]), request));
        }
        actions.add(UxRefreshSchemaStatsQueryMeta.createAction(context, loadedSchema.getName()));
        actions.add(UxSchemaStatsFileQueryMeta.createAction(context, loadedSchema.getName()));
        actions.add(UxDownloadSchemaStatsFileQueryMeta.createAction(context, loadedSchema.getName()));
        actions.add(UxSchemaFileQueryMeta.createAction(context, factoryFileName.relativePath()));
        actions.add(UxDownloadSchemaFileQueryMeta.createAction(context, factoryFileName.relativePath()));
        return actions;
    }

    private static List<UxAction> createUseCaseActionsForUnloadedSchema(UxQueryContext context, UxSchemaFactoryFile factoryFileName) {
        List<UxAction> actions = SchemaInfo.createActions(context);
        actions.add(UxLoadSchemaQueryMeta.createLoadAction(context, factoryFileName.relativePath()));
        actions.add(UxDeleteSchemaFileQueryMeta.createAction(context, factoryFileName.relativePath(), context.getUseCase(UxAdminUseCaseName.UnloadedSchemas)));
        actions.add(UxLoadSchemaCreateOfflineQueryMeta.createAction(context, factoryFileName.relativePath()));
        actions.add(UxSchemaCreateOfflineQueryMeta.createAction(context, factoryFileName.relativePath()));
        actions.add(UxSchemaFileQueryMeta.createAction(context, factoryFileName.relativePath()));
        actions.add(UxDownloadSchemaFileQueryMeta.createAction(context, factoryFileName.relativePath()));
        return actions;
    }

    public static UxUseCase createUseCaseForLoading(UxQueryContext context, String requestUuid, String schema, UxSchemaFactoryFile factoryFile) {
        IcCubeRequestStatus request;
        UxBabylonService babylon = context.getUxBabylonService();
        String schemaPath = factoryFile.relativePath();
        String schemaName = schema;
        List<UxAction> actions = SchemaInfo.createActions(context);
        IcCubeRequestStatusManager manager = context.getRequestStatusManager();
        if (manager.isActive(requestUuid)) {
            actions.add(UxCancelRequestQueryMeta.createAction(context, requestUuid, 1));
        }
        if ((request = manager.getRequestStatus(requestUuid)) != null) {
            actions.add(UxRequestQueryMeta.createAction(context, babylon.translateActionCaption("LoadingRequest", new Serializable[0]), request));
        }
        UxSchemaId schemaId = new UxSchemaId(schemaName, schemaPath);
        return new UxUseCaseBuilder(context, SchemaInfo).withId(UxAdminUseCaseName.SchemaInfo.name() + "-" + schemaPath).withCaption(babylon.translateUseCaseCaption(UxAdminUseCaseName.SchemaInfo.name(), new Serializable[0])).withUrl(SchemaInfo.createQueryUrl(schemaId)).withExtraTitle(new UxUseCaseTitle(context.getUseCase(UxAdminUseCaseName.LoadingSchemas), schemaName, UxAdminUseCaseRepository.asBookmark(SchemaInfo.createQueryUrl(schemaId)))).withActions(actions).build(true);
    }

    public static UxUseCase createUseCaseForInvalid(UxQueryContext context, UxSchemaFactoryFile factoryFile) {
        UxBabylonService babylon = context.getUxBabylonService();
        String schemaPath = factoryFile.relativePath();
        List<UxAction> actions = SchemaInfo.createActions(context);
        actions.add(UxDeleteSchemaFileQueryMeta.createAction(context, schemaPath, context.getUseCase(UxAdminUseCaseName.InvalidSchemas)));
        actions.add(UxSchemaFileQueryMeta.createAction(context, schemaPath));
        actions.add(UxDownloadSchemaFileQueryMeta.createAction(context, schemaPath));
        UxSchemaId schemaId = new UxSchemaId(null, schemaPath);
        return new UxUseCaseBuilder(context, SchemaInfo).withId(UxAdminUseCaseName.SchemaInfo.name() + "-" + schemaPath).withCaption(babylon.translateUseCaseCaption(UxAdminUseCaseName.SchemaInfo.name(), new Serializable[0])).withUrl(SchemaInfo.createQueryUrl(schemaId)).withExtraTitle(new UxUseCaseTitle(context.getUseCase(UxAdminUseCaseName.InvalidSchemas), schemaPath, UxAdminUseCaseRepository.asBookmark(SchemaInfo.createQueryUrl(schemaId)))).withActions(actions).build(true);
    }

    public static UxUseCase createUseCaseForNothing(UxQueryContext context) {
        List<UxAction> actions = SchemaInfo.createActions(context);
        return new UxUseCaseBuilder(context, SchemaInfo).withId(UxAdminUseCaseName.SchemaInfo).withUrl(SchemaInfo.createQueryUrl(null)).withActions(actions).build(true);
    }
}

