/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.schema.UxAbstractSchemaQuery;
import crazydev.iccube.ux.admin.queries.schema.UxSaveSchemaFileQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.UxSchemaFileQueryMeta;
import crazydev.iccube.ux.admin.queries.utils.UxFileUtils;
import crazydev.iccube.ux.admin.queries.utils.UxFileWrapper;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import org.jetbrains.annotations.Nullable;

public class UxSchemaFileQuery
extends UxAbstractSchemaQuery {
    private final String schemaFile;
    @Nullable
    private OlapFile file;

    protected UxSchemaFileQuery(UxQueryMeta meta, OlapRequestId requestId, String schemaFile) {
        super(meta, requestId);
        this.schemaFile = schemaFile;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        if (!CdStringUtils.isNullOrBlank((String)this.schemaFile)) {
            this.file = queryContext.createSchemaFactoryFile(false, this.schemaFile);
        }
        String mimeType = "application/octet-stream";
        if (this.file != null) {
            mimeType = queryContext.getMimeTypeByExtension(this.file.getName());
        }
        UxFileWrapper wrapper = UxFileWrapper.forOlapFile(this.file, this.schemaFile, mimeType, false);
        UxAction save = UxSaveSchemaFileQueryMeta.createAction(queryContext, this.schemaFile);
        return UxFileUtils.createFileContent(queryContext, this.meta.queryName(), wrapper, save);
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(UxSchemaFileQueryMeta.createUseCase(queryContext, this.schemaFile));
    }
}

