/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.fs.CdVFileSystem;
import crazydev.common.fs.revision.CdVFileRevAction;
import crazydev.common.fs.revision.CdVFileRevActionOperation;
import crazydev.common.fs.revision.CdVFileRevHelperConf;
import crazydev.common.fs.revision.CdVFileRevManagerKind;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderMetaInformationRepository;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.schema.UxAbstractSchemaQuery;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.common.action.UxActionPerformed;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import jakarta.xml.bind.JAXBException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.Nullable;

public class UxSaveSchemaFileQuery
extends UxAbstractSchemaQuery {
    private final String filePath;
    @Nullable
    private final String fileContent;

    protected UxSaveSchemaFileQuery(UxQueryMeta meta, OlapRequestId requestId, String filePath, @Nullable String fileContent) {
        super(meta, requestId);
        this.filePath = filePath;
        this.fileContent = fileContent;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        String validatedFileContent;
        OlapFile file = null;
        if (!CdStringUtils.isNullOrBlank((String)this.filePath)) {
            file = queryContext.createSchemaFactoryFile(false, this.filePath);
        }
        if (file == null) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.FILE_NOT_FOUND, (Serializable[])new Serializable[]{this.filePath}));
        }
        try {
            OlapEngineComponent engine = queryContext.getOlapEngineComponent();
            OlapBuilderMetaInformationRepository metaInformation = engine.getBuilderMetaInformationRepository();
            validatedFileContent = UxBuilderSchemaService.validateSchemaDefinition(metaInformation, this.fileContent);
        }
        catch (JAXBException ex) {
            OlapLoggers.UX_REQUEST.error((Object)("could not save schema file [" + this.filePath + "]"), (Throwable)ex);
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.FILE_IO_ERROR, (Serializable[])new Serializable[]{ex.getMessage()}));
        }
        ByteArrayInputStream validatedFileContentI = new ByteArrayInputStream(validatedFileContent.getBytes(StandardCharsets.UTF_8));
        try {
            OlapRuntimeContext rContext = queryContext.asRuntimeContext();
            OlapDirectoriesResolved directories = rContext.getDirectoriesResolved();
            CdVFileRevActionOperation action = new CdVFileRevActionOperation(queryContext.getUserName(), "manually edited");
            CdVFileSystem vfs = directories.getVfs();
            CdVFileRevHelperConf configuration = new CdVFileRevHelperConf(CdVFileRevManagerKind.SCHEMA_CUBES, directories.getTmpDirectory(), directories.getCubesDirectory());
            vfs.saveOrUpdateWithRevision(configuration, file.__getUnderlying(), (InputStream)validatedFileContentI, (CdVFileRevAction)action);
            return UxReply.actionSuccess(new UxActionPerformed(true));
        }
        catch (IOException ex) {
            OlapLoggers.UX_REQUEST.error((Object)("could not save schema file [" + this.filePath + "]"), (Throwable)ex);
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.FILE_IO_ERROR, (Serializable[])new Serializable[]{ex.getMessage()}));
        }
    }
}

