/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.schema.OlapSchemaInformation;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.status.IcCubeRequestState;
import crazydev.iccube.request.status.IcCubeRequestStatus;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.ux.admin.queries.schema.UxAbstractSchemaQuery;
import crazydev.iccube.ux.admin.queries.schema.UxSchemaFactoryFile;
import crazydev.iccube.ux.admin.queries.schema.UxSchemaInfoQueryMeta;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.common.filter.UxFilterMeta;
import crazydev.iccube.ux.common.filter.UxFilterMetas;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableCell;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableMeta;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.common.table.UxTableRowSearcher;
import crazydev.iccube.ux.common.table.UxTableSortType;
import crazydev.iccube.ux.common.table.UxTableWithUseCasesReplyPayload;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class UxLoadingSchemasQuery
extends UxAbstractSchemaQuery {
    protected UxLoadingSchemasQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxTableOptions tableOptions) {
        super(meta, requestId, tableOptions);
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        UxBabylonService babylon = queryContext.getUxBabylonService();
        UxTableHeaders header = UxTableHeaders.create(babylon, "group", "schema", "startTime", "status", "progress", "user");
        UxFilterMetas filterMetas = new UxFilterMetas(new UxFilterMeta<SchemaInfo>("group", babylon.translate("filterSchemaGroup", new Serializable[0]), SchemaInfo::getGroup), new UxFilterMeta<SchemaInfo>("schema", babylon.translate("filterSchemaName", new Serializable[0]), SchemaInfo::getName));
        UxTableRowSearcher<SchemaInfo> searcher = new UxTableRowSearcher<SchemaInfo>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public boolean isAccepting(SchemaInfo row, String searchText) {
                return this.isContaining(searchText, row.getName(), row.getGroup());
            }
        };
        IcCubeRequestStatusManager requests = queryContext.getRequestStatusManager();
        OlapEngineComponent engine = queryContext.getOlapEngineComponent();
        OlapRuntimeContext rContext = queryContext.asRuntimeContext();
        List<SchemaInfo> loadingSchemas = this.filter(this.tableOptions, searcher, filterMetas, this.getLoadingSchemas(requests, engine, rContext));
        int totalRowCount = loadingSchemas.size();
        UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.createForFirstPageWithDefaults(queryContext.getApi(), "schema", UxTableSortType.asc, totalRowCount));
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        for (SchemaInfo loadingSchema : loadingSchemas) {
            rows.add(UxLoadingSchemasQuery.createRow(queryContext, loadingSchema));
        }
        UxTable table = UxTable.create(options, header, rows);
        UxTableMeta tableMeta = new UxTableMeta(searcher != null, filterMetas);
        return UxReply.success(new UxTableWithUseCasesReplyPayload(tableMeta, table));
    }

    private List<SchemaInfo> getLoadingSchemas(IcCubeRequestStatusManager requests, OlapEngineComponent engine, OlapRuntimeContext context) {
        HashMap<String, SchemaInfo> loading = new HashMap<String, SchemaInfo>();
        List schemas = engine.getAllLoadingSchemaInformation(context, false);
        for (OlapSchemaInformation schema : schemas) {
            loading.put(schema.getName(), new SchemaInfo(schema.getRequestUuid(), schema.getGroup(), schema.getName(), schema.getFactoryFile()));
        }
        List actives = requests.getAllActiveLoadingSchemaRequestStatus(context.getTenant());
        for (IcCubeRequestStatus active : actives) {
            String schema;
            if (!active.isLoadSchema() || !CdStringUtils.isNotNullAndNotBlank((String)(schema = active.getSchema())) || loading.containsKey(schema)) continue;
            loading.put(schema, new SchemaInfo(active.getRequestUUID(), null, schema, active.getSchemaFactory()));
        }
        return new ArrayList<SchemaInfo>(loading.values());
    }

    private static UxTableRow createRow(UxQueryContext context, SchemaInfo schema) {
        UxBabylonService babylon = context.getUxBabylonService();
        String uuid = schema.getRequestUUID();
        ArrayList<UxTableCell> cells = new ArrayList<UxTableCell>();
        cells.add(new UxTableCell(schema.getGroup()));
        File factoryFile = schema.getFactoryFile();
        UxUseCase useCase = null;
        if (factoryFile != null) {
            useCase = UxSchemaInfoQueryMeta.createUseCaseForLoading(context, uuid, schema.getName(), UxSchemaFactoryFile.fromFile(context, false, factoryFile));
        }
        cells.add(new UxTableCell((Object)schema.getName(), useCase));
        IcCubeRequestStatusManager manager = context.getRequestStatusManager();
        IcCubeRequestStatus status = manager.getRequestStatus(uuid);
        if (status != null) {
            cells.add(new UxTableCell(status.getStartDateServerTimeForRequest()).withValue_(status.getStartDate()));
            cells.add(new UxTableCell(babylon.translateEnum(IcCubeRequestState.class, status.getState().name())).withValue_(status.getState()));
            cells.add(new UxTableCell(status.getLocalizedProgressInformation(context.getOlapBabylonService())));
            cells.add(new UxTableCell(status.getUserName()));
        } else {
            cells.add(new UxTableCell("-").withValue_(new Date()));
            cells.add(new UxTableCell("-").withValue_(IcCubeRequestState.RECEIVED));
            cells.add(new UxTableCell("-"));
            cells.add(new UxTableCell("-"));
        }
        return new UxTableRow(cells);
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxAdminUseCaseName.LoadingSchemas));
    }

    static class SchemaInfo {
        @Nullable
        final String group;
        final String name;
        final File factoryFile;
        private final String requestUUID;

        public SchemaInfo(String requestUUID, @Nullable String group, String name, File factoryFile) {
            this.requestUUID = requestUUID;
            this.group = group;
            this.name = name;
            this.factoryFile = factoryFile;
        }

        public String getRequestUUID() {
            return this.requestUUID;
        }

        @Nullable
        public String getGroup() {
            return this.group;
        }

        public String getName() {
            return this.name;
        }

        public File getFactoryFile() {
            return this.factoryFile;
        }
    }
}

