/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema;

import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.component.schemas.OlapSchemaFactoryInfo;
import crazydev.iccube.olap.schema.OlapSchemaInformation;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.schema.UxAbstractSchemaQuery;
import crazydev.iccube.ux.admin.queries.schema.UxSchemaStatus;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableCell;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.common.table.UxTableSortType;
import crazydev.iccube.ux.common.table.UxTableWithUseCasesReplyPayload;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class UxListSchemasQuery
extends UxAbstractSchemaQuery {
    protected UxListSchemasQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxTableOptions tableOptions) {
        super(meta, requestId, tableOptions);
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        UxBabylonService babylon = queryContext.getUxBabylonService();
        UxTableHeaders header = UxTableHeaders.create(babylon, "schemaFactoryFile", "schemaName", "schemaStatus", "schemaLoading");
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        OlapRuntimeContext rContext = queryContext.asRuntimeContext();
        OlapEngineComponent engine = queryContext.getOlapEngineComponent();
        ArrayList factories = new ArrayList();
        engine.foreachSchemaFactoryFile(rContext, factoryFile -> {
            factories.add(factoryFile);
            return true;
        });
        for (File factory : factories) {
            OlapSchemaFactoryInfo info = engine.getSchemaFactoryInfo(rContext, factory);
            if (info == null) {
                rows.add(this.createRowForInvalid(queryContext, factory));
                continue;
            }
            rows.add(this.createRowForValid(queryContext, info));
        }
        int totalRowCount = factories.size();
        UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.createForFirstPageWithDefaults(queryContext.getApi(), "schema", UxTableSortType.asc, totalRowCount));
        UxTable table = UxTable.create(options, header, rows);
        return UxReply.success(new UxTableWithUseCasesReplyPayload(table));
    }

    private UxTableRow createRowForInvalid(UxQueryContext queryContext, File factory) {
        ArrayList<UxTableCell> cells = new ArrayList<UxTableCell>();
        cells.add(new UxTableCell(factory.getName()));
        cells.add(new UxTableCell(""));
        cells.add(new UxTableCell("INVALID"));
        cells.add(new UxTableCell(""));
        return new UxTableRow(cells);
    }

    private UxTableRow createRowForValid(UxQueryContext queryContext, OlapSchemaFactoryInfo info) {
        String status;
        OlapRuntimeContext rContext = queryContext.asRuntimeContext();
        OlapEngineComponent engine = queryContext.getOlapEngineComponent();
        boolean loading = engine.isSchemaLoading(rContext, info.getFile());
        OlapSchemaInformation loadedSchema = engine.getLoadedSchemaInformation(rContext, info.getFile());
        String latestErrors = UxListSchemasQuery.getLatestErrors(queryContext, info.getName(), info.getFile());
        if (loadedSchema != null) {
            babylon = queryContext.getUxBabylonService();
            status = latestErrors != null ? babylon.translateEnum(UxSchemaStatus.class, UxSchemaStatus.LOADED_REFRESH_FAILED.name()) : babylon.translateEnum(UxSchemaStatus.class, UxSchemaStatus.LOADED.name());
        } else {
            babylon = queryContext.getUxBabylonService();
            status = latestErrors != null ? babylon.translateEnum(UxSchemaStatus.class, UxSchemaStatus.UNLOADED_REFRESH_FAILED.name()) : babylon.translateEnum(UxSchemaStatus.class, UxSchemaStatus.UNLOADED.name());
        }
        ArrayList<UxTableCell> cells = new ArrayList<UxTableCell>();
        cells.add(new UxTableCell(info.getFile().getName()));
        cells.add(new UxTableCell(info.getName()));
        cells.add(new UxTableCell(status));
        cells.add(new UxTableCell(loading ? "LOADING" : ""));
        return new UxTableRow(cells);
    }
}

