/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.schema.UxAbstractSchemaQuery;
import crazydev.iccube.ux.admin.queries.utils.UxFileWrapper;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxAttachmentReply;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxDownloadSchemaFileQuery
extends UxAbstractSchemaQuery {
    @Nullable
    private final String schemaFile;
    @Nullable
    private OlapFile file;

    protected UxDownloadSchemaFileQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String schemaFile) {
        super(meta, requestId);
        this.schemaFile = schemaFile;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        if (!CdStringUtils.isNullOrBlank((String)this.schemaFile)) {
            this.file = queryContext.createSchemaFactoryFile(false, this.schemaFile);
        }
        if (this.file == null) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.FILE_NOT_FOUND, (Serializable[])new Serializable[]{this.schemaFile}));
        }
        String mimeType = queryContext.getMimeTypeByExtension(this.file.getName());
        UxFileWrapper wrapper = UxFileWrapper.forOlapFile(this.file, this.schemaFile, mimeType, false);
        return new UxAttachmentReply(wrapper, null);
    }
}

