/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema;

import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.schema.stats.OlapSchemaStats;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.schema.UxAbstractSchemaQuery;
import crazydev.iccube.ux.admin.queries.utils.UxFileWrapper;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import org.jetbrains.annotations.Nullable;

public abstract class UxAbstractSchemaStatsFileQuery
extends UxAbstractSchemaQuery {
    @Nullable
    protected final String schemaName;

    protected UxAbstractSchemaStatsFileQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String schemaName) {
        super(meta, requestId);
        this.schemaName = schemaName;
    }

    protected UxFileWrapper createFileWrapper(UxQueryContext queryContext) {
        return this.createFileWrapper(queryContext, false);
    }

    @Nullable
    protected UxFileWrapper createFileWrapperX(UxQueryContext queryContext) {
        return this.createFileWrapper(queryContext, true);
    }

    @Nullable
    private UxFileWrapper createFileWrapper(UxQueryContext queryContext, boolean nullable) {
        boolean available;
        String stats;
        if (this.schemaName != null) {
            OlapRuntimeContext rContext;
            OlapEngineComponent engine = queryContext.getOlapEngineComponent();
            OlapSchemaStats statistics = engine.getLoadedSchemaStatistics(rContext = queryContext.asRuntimeContext(), this.schemaName);
            if (statistics != null) {
                stats = statistics.print(false);
                available = true;
            } else {
                stats = "n/a";
                available = false;
            }
        } else {
            stats = "n/a";
            available = false;
        }
        if (nullable && !available) {
            return null;
        }
        String fileName = this.schemaName + "-stats.txt";
        String mimeType = queryContext.getMimeTypeByExtension(fileName);
        return UxFileWrapper.forString(fileName, stats, mimeType);
    }
}

