/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema;

import com.google.gson.Gson;
import crazydev.iccube.builder.datasource.facts.OlapBuilderFacts;
import crazydev.iccube.builder.datasource.facts.OlapBuilderLinkXmlDefinition;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderCubeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.def.OlapBuilderDataViewLinksType;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.naming.OlapDefaultNamesContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.permissions.IOlapCubePermission;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionPermission;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionsPermission;
import crazydev.iccube.olap.entity.permissions.IOlapHierarchyPermission;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import crazydev.iccube.ux.admin.queries.schema.UxAISchemaInfoFormat;
import crazydev.iccube.ux.admin.queries.schema.UxAISchemaInfoGranularity;
import crazydev.iccube.ux.admin.queries.schema.UxAISchemaInfoReplyPayload;
import crazydev.iccube.ux.admin.queries.schema.UxAbstractSchemaQuery;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.util.Strings;
import org.jetbrains.annotations.Nullable;

public class UxAISchemaInfoQuery
extends UxAbstractSchemaQuery {
    private final String schemaName;
    private final UxAISchemaInfoFormat format;
    private final UxAISchemaInfoGranularity granularity;
    @Nullable
    private final String facts;

    protected UxAISchemaInfoQuery(UxQueryMeta meta, OlapRequestId requestId, String schemaName, @Nullable UxAISchemaInfoFormat format, @Nullable UxAISchemaInfoGranularity granularity, @Nullable String facts) {
        super(meta, requestId, null);
        this.schemaName = schemaName;
        this.format = format != null ? format : UxAISchemaInfoFormat.MDX;
        this.granularity = granularity != null ? granularity : UxAISchemaInfoGranularity.HIERARCHY;
        this.facts = facts;
    }

    @Override
    @Nullable
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public IcCubeSchemaAccessLockMode getSchemaAccessLockMode() {
        return IcCubeSchemaAccessLockMode.READ;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        OlapEngineRequestContext eContext = queryContext.getOlapEngineRequestContext();
        OlapEngineComponent engine = eContext.getOlapEngineComponent();
        OlapSchema schema = engine.getAuthorizedSchema(eContext, IcCubeSchemaAccessLockMode.READ, this.schemaName);
        if (schema == null) {
            return UxReply.success(new UxAISchemaInfoReplyPayload());
        }
        ArrayList<UxAISchemaInfoReplyPayload.Table> tablesInfo = new ArrayList<UxAISchemaInfoReplyPayload.Table>();
        ArrayList<UxAISchemaInfoReplyPayload.Facts> factsInfo = new ArrayList<UxAISchemaInfoReplyPayload.Facts>();
        IOlapBuilderSchemaDef schemaDef = schema.getDefinitionFactory().getSchemaDefinition();
        IOlapSchemaPermission schemaPerms = eContext.getSchemaPermissions(schema);
        ArrayList<OlapCube> sortedCubes = new ArrayList<OlapCube>(schema.getCubes(schemaPerms));
        sortedCubes.sort(Comparator.comparing(OlapCube::getNameX));
        for (OlapCube cube : sortedCubes) {
            IOlapDimensionsPermission dimensionsPermissions = schemaPerms.getDimensionsPermissions(cube);
            Map dimensions = schema.getDimensions(dimensionsPermissions).stream().collect(Collectors.toMap(OlapDimension::getNameX, Function.identity()));
            IOlapCubePermission cubePerms = schemaPerms.getCubePermissions(cube);
            ArrayList sortedFacts = new ArrayList(cube.getMeasureGroupNames(cubePerms));
            sortedFacts.sort(String::compareTo);
            for (int ff = 0; ff < sortedFacts.size(); ++ff) {
                String facts = (String)sortedFacts.get(ff);
                if (this.facts != null && !this.facts.equals(facts)) continue;
                List measures = cube.getMeasuresMembers(schemaPerms, facts);
                ArrayList<String> measureNames = new ArrayList<String>();
                HashSet<String> measureDisplayFoldersS = new HashSet<String>();
                for (OlapMeasureMember measure : measures) {
                    measureNames.add(measure.getNameX());
                    String folder = measure.getDisplayFolder(Locale.ENGLISH, OlapDefaultNamesContext.DEFAULT_VALUES);
                    if (folder == null) continue;
                    measureDisplayFoldersS.add(folder);
                }
                ArrayList measureDisplayFolders = new ArrayList(measureDisplayFoldersS);
                measureNames.sort(String::compareTo);
                measureDisplayFolders.sort(String::compareTo);
                ArrayList<String> dimensionNames = new ArrayList<String>();
                ArrayList<String> hierarchyNames = new ArrayList<String>();
                ArrayList<String> levelNames = new ArrayList<String>();
                List<OlapBuilderLinkXmlDefinition> links = this.getLinks(schemaDef, cube.getNameX(), facts);
                for (OlapBuilderLinkXmlDefinition link : links) {
                    String id = link.getDimensionId();
                    IOlapBuilderDimensionDef dimensionDef = schema.getDimensionDefinition(id);
                    OlapDimension dimension = (OlapDimension)dimensions.get(dimensionDef.getName());
                    if (dimension == null) continue;
                    dimensionNames.add(dimension.getNameX());
                    IOlapDimensionPermission dimensionPermissions = dimensionsPermissions.getDimensionPermissions(dimension);
                    List hierarchies = dimension.getHierarchies(dimensionPermissions);
                    for (OlapHierarchy hierarchy : hierarchies) {
                        hierarchyNames.add(hierarchy.getNameX());
                        IOlapHierarchyPermission hierarchyPermission = dimensionPermissions.getHierarchyPermission(hierarchy);
                        List levels = hierarchy.getLevels(hierarchyPermission);
                        for (OlapLevel level : levels) {
                            if (level.isAll()) continue;
                            levelNames.add(level.getNameX());
                        }
                    }
                }
                dimensionNames.sort(String::compareTo);
                hierarchyNames.sort(String::compareTo);
                levelNames.sort(String::compareTo);
                OlapLoggers.REQUEST.debug((Object)("[ai] --------- facts : " + ff + " " + facts + " --------------------------------------- "));
                OlapLoggers.REQUEST.debug((Object)("[ai]        measures : " + measures.size() + " " + Strings.join(measureNames, (char)',')));
                OlapLoggers.REQUEST.debug((Object)("[ai] display-folders : " + measureDisplayFolders.size() + " " + Strings.join(measureDisplayFolders, (char)',')));
                OlapLoggers.REQUEST.debug((Object)("[ai]      dimensions : " + dimensionNames.size() + " " + Strings.join(dimensionNames, (char)',')));
                OlapLoggers.REQUEST.debug((Object)("[ai]     hierarchies : " + hierarchyNames.size() + " " + Strings.join(hierarchyNames, (char)',')));
                OlapLoggers.REQUEST.debug((Object)("[ai]          levels : " + levelNames.size() + " " + Strings.join(levelNames, (char)',')));
                if (this.format == UxAISchemaInfoFormat.SQL) {
                    ArrayList<String> columns = new ArrayList<String>(measureNames);
                    if (this.granularity == UxAISchemaInfoGranularity.HIERARCHY) {
                        columns.addAll(hierarchyNames);
                    } else if (this.granularity == UxAISchemaInfoGranularity.LEVEL) {
                        columns.addAll(levelNames);
                    }
                    tablesInfo.add(new UxAISchemaInfoReplyPayload.Table(facts, columns));
                    continue;
                }
                if (this.format != UxAISchemaInfoFormat.MDX) continue;
                if (this.granularity == UxAISchemaInfoGranularity.HIERARCHY) {
                    factsInfo.add(new UxAISchemaInfoReplyPayload.Facts(facts, measureNames, hierarchyNames));
                    continue;
                }
                if (this.granularity != UxAISchemaInfoGranularity.LEVEL) continue;
                factsInfo.add(new UxAISchemaInfoReplyPayload.Facts(facts, measureNames, levelNames));
            }
        }
        OlapLoggers.REQUEST.debug((Object)("[ai] tables : " + new Gson().toJson(tablesInfo)));
        OlapLoggers.REQUEST.debug((Object)("[ai] facts  : " + new Gson().toJson(factsInfo)));
        switch (this.format) {
            case SQL: {
                return UxReply.success(UxAISchemaInfoReplyPayload.ofTables(tablesInfo));
            }
            case MDX: {
                return UxReply.success(UxAISchemaInfoReplyPayload.ofFacts(factsInfo));
            }
        }
        return UxReply.success(new UxAISchemaInfoReplyPayload());
    }

    private List<OlapBuilderLinkXmlDefinition> getLinks(IOlapBuilderSchemaDef schemaDef, String cube, String facts) {
        IOlapBuilderBaseFactsDef factsDef;
        IOlapBuilderCubeDef cubeDef = schemaDef.getCubes().stream().filter(def -> def.getName().equals(cube)).findFirst().orElse(null);
        if (cubeDef != null && (factsDef = cubeDef.getFacts(facts)) != null && factsDef instanceof OlapBuilderFacts) {
            OlapBuilderFacts factsB = (OlapBuilderFacts)factsDef;
            return factsB.getLinks().stream().filter(link -> {
                OlapBuilderDataViewLinksType type = link.getLink().getType();
                return type == OlapBuilderDataViewLinksType.LAST_LEVEL || type == OlapBuilderDataViewLinksType.ALL_LEVELS || type == OlapBuilderDataViewLinksType.INTERMEDIATE_LEVEL || type == OlapBuilderDataViewLinksType.LEVEL_LIST || type == OlapBuilderDataViewLinksType.RANGE_FROM_TO || type == OlapBuilderDataViewLinksType.MANY_TO_MANY;
            }).toList();
        }
        return Collections.emptyList();
    }
}

