/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.runtime.sessions;

import crazydev.iccube.olap.eval.cache.IOlapSessionCacheManager;
import crazydev.iccube.olap.eval.cache.OlapCacheManager;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.ux.admin.queries.UxAdminQuery;
import crazydev.iccube.ux.admin.queries.runtime.sessions.UxSessionInfo;
import crazydev.iccube.ux.admin.queries.runtime.sessions.UxSessionLogoutQueryMeta;
import crazydev.iccube.ux.admin.queries.utils.UxRowFilters;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.filter.UxFilterMeta;
import crazydev.iccube.ux.common.filter.UxFilterMetas;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.style.UxStyleLevel;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableCell;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableMeta;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableReplyPayload;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.common.table.UxTableRowSearcher;
import crazydev.iccube.ux.common.table.UxTableSearcher;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class UxSessionsQuery
extends UxAdminQuery {
    @Nullable
    private final UxTableOptions tableOptions;

    protected UxSessionsQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxTableOptions tableOptions) {
        super(meta, requestId);
        this.tableOptions = tableOptions;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        UxBabylonService babylon = queryContext.getUxBabylonService();
        UxTableHeaders header = UxTableHeaders.create(babylon, "user", "role", "sessionCreationTime", "sessionLastUsedTime", "uuid", "action");
        UxFilterMetas filterMetas = new UxFilterMetas(new UxFilterMeta<IOlapSessionCacheManager>("user", babylon.translate("filterSessionUser", new Serializable[0]), IOlapSessionCacheManager::getUserName), new UxFilterMeta<IOlapSessionCacheManager>("role", babylon.translate("filterSessionRole", new Serializable[0]), IOlapSessionCacheManager::getUserRoleName), new UxFilterMeta<IOlapSessionCacheManager>("uuid", babylon.translate("filterSessionUUID", new Serializable[0]), IOlapSessionCacheManager::getUUID));
        UxTableSearcher rowSearcher = this.setupRowSearcher(this.tableOptions, new UxTableRowSearcher<IOlapSessionCacheManager>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public boolean isAccepting(IOlapSessionCacheManager row, String searchText) {
                return this.isContaining(searchText, row.getUserName(), row.getUserRoleName());
            }
        });
        UxRowFilters rowFilters = this.setupRowFilters(this.tableOptions, filterMetas);
        IcCubeServerApplicationContext appContext = queryContext.getApplicationContext();
        OlapCacheManager cacheManager = appContext.getCacheManager();
        ArrayList sessions = new ArrayList();
        cacheManager.forEachSession(session -> {
            if ((rowSearcher == null || rowSearcher.isAccepting(session)) && (rowFilters == null || rowFilters.isAccepting(session))) {
                sessions.add(new UxSessionInfo(session.getUUID(), session.getUserName(), session.getUserRoleName(), session.getCreateTimestampMS(), session.getLastUsedTimestampMS()));
            }
        });
        sessions.sort((o1, o2) -> -o1.getLastUsedTime().compareTo(o2.getLastUsedTime()));
        int totalRowCount = sessions.size();
        UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.createForFirstPageWithDefaults(queryContext.getApi(), totalRowCount));
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        for (UxSessionInfo session2 : sessions) {
            rows.add(UxSessionsQuery.createRow(queryContext, session2));
        }
        UxTable table = UxTable.create(options, header, rows);
        UxTableMeta tableMeta = new UxTableMeta(true, filterMetas);
        return UxReply.success(new UxTableReplyPayload(tableMeta, table));
    }

    private static UxTableRow createRow(UxQueryContext context, UxSessionInfo session) {
        String uuid = session.getUUID();
        ArrayList<UxTableCell> cells = new ArrayList<UxTableCell>();
        cells.add(new UxTableCell(session.getUser()));
        cells.add(new UxTableCell(session.getRole()));
        cells.add(new UxTableCell(session.getLoginTimeServerTime()).withValue_(session.getLoginTime()));
        cells.add(new UxTableCell(session.getLastUsedTimeServerTime()).withValue_(session.getLastUsedTime()));
        cells.add(new UxTableCell(uuid));
        UxAction action = UxSessionLogoutQueryMeta.createAction(context, uuid);
        if (action != null) {
            cells.add(new UxTableCell((Object)action.caption(), action));
        } else {
            cells.add(new UxTableCell(""));
        }
        String sessionUUID = context.getSessionContext().getSessionId();
        if (sessionUUID.equals(uuid)) {
            return new UxTableRow(cells).withStyle(UxStyleLevel.MYSELF);
        }
        return new UxTableRow(cells);
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxAdminUseCaseName.Sessions));
    }
}

