/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.runtime.sessions;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.eval.cache.IOlapSessionCacheManager;
import crazydev.iccube.olap.eval.cache.OlapCacheManager;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.authentication.IOlapAuthenticationService;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.server.context.IcCubeServerSessionContext;
import crazydev.iccube.ux.admin.queries.UxAdminQuery;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import jakarta.servlet.http.HttpSession;
import org.jetbrains.annotations.Nullable;

public class UxSessionLogoutQuery
extends UxAdminQuery {
    @Nullable
    private final String uuid;

    protected UxSessionLogoutQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String uuid) {
        super(meta, requestId);
        this.uuid = uuid;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        IcCubeServerSessionContext sessionContext = queryContext.getSessionContext();
        UxSessionLogoutQuery.logout(sessionContext, this.uuid);
        return UxReply.actionSuccess();
    }

    public static void logout(IcCubeServerSessionContext sessionContext, @Nullable String sessionId) {
        if (CdStringUtils.isNullOrBlank((String)sessionId)) {
            return;
        }
        IcCubeServerApplicationContext appContext = sessionContext.getApplicationContext();
        OlapCacheManager cacheManager = appContext.getCacheManager();
        IOlapSessionCacheManager session = cacheManager.getSession(sessionId);
        if (session != null) {
            HttpSession httpSession = session.getHttpSession();
            if (httpSession != null) {
                UxSessionLogoutQuery.logoutHttpSession(appContext, httpSession, sessionId);
                try {
                    httpSession.invalidate();
                }
                catch (RuntimeException ex) {
                    OlapLoggers.GENERAL.warn((Object)("[session] could not invalidate the session [" + sessionId + "]"));
                    IcCubeServerSessionContext.onSessionDestroyed(httpSession);
                }
            } else {
                cacheManager.unregisterSession(session);
            }
        }
    }

    private static void logoutHttpSession(IcCubeServerApplicationContext appContext, HttpSession session, String sessionId) {
        try {
            IOlapAuthenticationService service = (IOlapAuthenticationService)appContext.getServletContextAttribute("icCube.authenticationService");
            if (service != null) {
                service.logout(session);
            }
        }
        catch (RuntimeException ex) {
            OlapLoggers.GENERAL.warn((Object)("[session] could not logout the HTTP session [" + sessionId + "] [" + session.getId() + "]"));
        }
    }
}

