/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.runtime.request;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.ux.admin.queries.UxAdminQuery;
import crazydev.iccube.ux.admin.queries.runtime.request.UxCancelRequestStatus;
import crazydev.iccube.ux.admin.queries.runtime.request.UxRequestsQueryMeta;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxCancelRequestExQuery
extends UxAdminQuery {
    @Nullable
    private final String uuid;

    protected UxCancelRequestExQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String uuid) {
        super(meta, requestId);
        this.uuid = uuid;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        String message;
        boolean cancelled;
        String me = this.getRequestId().getClientUUID();
        if (CdStringUtils.isNullOrBlank((String)this.uuid) || me.equals(this.uuid)) {
            return UxReply.actionSuccess();
        }
        IcCubeRequestStatusManager manager = queryContext.getRequestStatusManager();
        UxBabylonService babylon = queryContext.getUxBabylonService();
        String title = babylon.translate("cancelRequestTitle", new Serializable[0]);
        UxAction activeRequests = UxRequestsQueryMeta.createActiveQueries(queryContext);
        if (manager.cancelRequestEx(this.uuid)) {
            cancelled = true;
            message = babylon.translate("cancelRequestMessageYes", new Serializable[0]);
        } else {
            cancelled = false;
            message = babylon.translate("cancelRequestMessageNo", new Serializable[0]);
        }
        return UxReply.actionSuccess(new UxCancelRequestStatus(cancelled, title, message, activeRequests));
    }
}

