/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.runtime.printing;

import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.server.request.processor.print.IcCubePrintService;
import crazydev.iccube.server.request.processor.print.chrome.IcCubeChromePrintService;
import crazydev.iccube.server.request.processor.print.chrome.IcCubeDockerPrintService;
import crazydev.iccube.ux.admin.queries.UxAdminQuery;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxAttachmentReply;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.table.UxPropertyTableReplyPayload;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.processor.UxBabylonService;
import io.webfolder.cdp.type.browser.GetVersionResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class UxPrintServerStatusQuery
extends UxAdminQuery {
    @Nullable
    private final UxTableOptions tableOptions;
    private final boolean download;

    protected UxPrintServerStatusQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxTableOptions tableOptions, boolean download) {
        super(meta, requestId);
        this.tableOptions = tableOptions;
        this.download = download;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        IcCubeServerApplicationContext appContext = queryContext.getApplicationContext();
        UxBabylonService babylon = queryContext.getUxBabylonService();
        UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.create());
        UxTableHeaders header = UxTableHeaders.create(babylon, "property", "value");
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        IcCubePrintService service = appContext.getPrintService();
        if (service instanceof IcCubeChromePrintService) {
            IcCubeChromePrintService serviceC = (IcCubeChromePrintService)service;
            this.values(queryContext, values, serviceC);
        } else if (service instanceof IcCubeDockerPrintService) {
            IcCubeDockerPrintService serviceD = (IcCubeDockerPrintService)service;
            this.values(queryContext, values, serviceD);
        } else if (service != null) {
            this.pLvL(queryContext, values, "status", "notAvailable");
        } else {
            this.pLvL(queryContext, values, "status", "notEnabled");
        }
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        for (Map.Entry entry : values.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            rows.add(UxTableRow.createAsPreValue(key, value));
        }
        UxTable table = UxTable.create(!this.download ? options : null, header, rows);
        if (this.download) {
            return new UxAttachmentReply(table.asFileWrapper(queryContext), "ic3-print-server-status.csv");
        }
        return UxReply.success(new UxPropertyTableReplyPayload(table));
    }

    private void pLvL(UxQueryContext context, LinkedHashMap<String, String> values, String propertyTag, String valueTag) {
        boolean isForRestApi = context.isForRestApi();
        if (!isForRestApi) {
            UxBabylonService babylon = context.getUxBabylonService();
            values.put(babylon.translate(propertyTag, new Serializable[0]), babylon.translate(valueTag, new Serializable[0]));
        } else {
            values.put(propertyTag, valueTag);
        }
    }

    private void pLv(UxQueryContext context, LinkedHashMap<String, String> values, String propertyTag, String value) {
        boolean isForRestApi = context.isForRestApi();
        if (!isForRestApi) {
            UxBabylonService babylon = context.getUxBabylonService();
            values.put(babylon.translate(propertyTag, new Serializable[0]), value);
        } else {
            values.put(propertyTag, value);
        }
    }

    private void values(UxQueryContext queryContext, LinkedHashMap<String, String> values, IcCubeChromePrintService service) {
        String pid;
        this.pLv(queryContext, values, "psMaxActiveCount", "" + service.getMaxActiveCount());
        this.pLv(queryContext, values, "psJobPermits", service.getPermitCount());
        this.pLvL(queryContext, values, "psRunning", service.isRunning() ? "psYes" : "psNo");
        GetVersionResult version = service.getVersion();
        if (version != null) {
            boolean isForRestApi = queryContext.isForRestApi();
            if (!isForRestApi) {
                values.put("Chrome|Chromium", "Product    : " + version.getProduct() + "\nRevision   : " + version.getRevision() + "\nUser Agent : " + version.getUserAgent() + "\nProtocol   : " + version.getProtocolVersion() + "\nJavascript : " + version.getJsVersion() + "\n");
            } else {
                values.put("chromeProduct", version.getProduct());
                values.put("chromeRevision", version.getRevision());
                values.put("chromeUserAgent", version.getUserAgent());
                values.put("chromeProtocolVersion", version.getProtocolVersion());
                values.put("chromeJsVersion", version.getJsVersion());
            }
        }
        if ((pid = service.getPID()) != null) {
            this.pLv(queryContext, values, "psPID", pid);
        } else {
            this.pLvL(queryContext, values, "psPID", "notAvailable");
        }
        String debug = service.getDebug();
        if (debug != null) {
            this.pLv(queryContext, values, "psDebugInfo", debug);
        } else {
            this.pLvL(queryContext, values, "psDebugInfo", "notAvailable");
        }
        this.pLv(queryContext, values, "psJobCountTotal", "" + service.getJobCountTotal());
        Date startTime = service.getStartTime();
        if (startTime != null) {
            this.pLv(queryContext, values, "psStartTime", CdTimeUtils.formatServerTimeForRequest((Date)startTime));
        } else {
            this.pLvL(queryContext, values, "psStartTime", "notAvailable");
        }
        this.pLv(queryContext, values, "psJobCountUptime", "" + service.getJobCountUptime());
    }

    private void values(UxQueryContext queryContext, LinkedHashMap<String, String> values, IcCubeDockerPrintService service) {
        Object value;
        String key;
        UxBabylonService babylon = queryContext.getUxBabylonService();
        boolean isForRestApi = queryContext.isForRestApi();
        LinkedHashMap<String, Object> status = service.getStatus();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : status.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            if (!key.startsWith("chrome")) continue;
            if (!isForRestApi) {
                sb.append(String.format("%15.15s: %s\n", babylon.translate(key, new Serializable[0]), value));
                continue;
            }
            values.put(key, String.valueOf(value));
        }
        if (!isForRestApi) {
            if (sb.isEmpty()) {
                sb.append(babylon.translate("notAvailable", new Serializable[0]));
            }
            values.put("Chrome|Chromium", sb.toString());
        }
        for (Map.Entry<String, Object> entry : status.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            if (key.startsWith("chrome")) continue;
            if (isForRestApi) {
                values.put(key, String.valueOf(value));
                continue;
            }
            this.pLv(queryContext, values, key, String.valueOf(this.fixInt(value)));
        }
    }

    private Object fixInt(Object value) {
        Number valueN;
        double valueD;
        if (value instanceof Number && (valueD = (valueN = (Number)value).doubleValue()) == (double)((int)valueD)) {
            return valueN.intValue();
        }
        return value;
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxAdminUseCaseName.PrintServerStatus));
    }
}

