/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.runtime.printing;

import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.server.request.processor.print.IcCubePrintJobStatus;
import crazydev.iccube.server.request.processor.print.IcCubePrintService;
import crazydev.iccube.ux.admin.queries.UxAdminQuery;
import crazydev.iccube.ux.admin.queries.runtime.request.UxRequestQueryMeta;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.common.filter.UxFilterMeta;
import crazydev.iccube.ux.common.filter.UxFilterMetas;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableCell;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableMeta;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.common.table.UxTableRowSearcher;
import crazydev.iccube.ux.common.table.UxTableWithUseCasesReplyPayload;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class UxPrintJobsQuery
extends UxAdminQuery {
    @Nullable
    private final UxTableOptions tableOptions;

    protected UxPrintJobsQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxTableOptions tableOptions) {
        super(meta, requestId);
        this.tableOptions = tableOptions;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        IcCubeServerApplicationContext appContext = queryContext.getApplicationContext();
        IcCubePrintService service = appContext.getPrintService();
        if (service != null) {
            return this.executeQueryForChrome(queryContext, service);
        }
        return UxReply.success(new UxTableWithUseCasesReplyPayload(null, UxTable.empty()));
    }

    private UxReply executeQueryForChrome(UxQueryContext queryContext, IcCubePrintService service) {
        UxBabylonService babylon = queryContext.getUxBabylonService();
        UxTableHeaders header = UxTableHeaders.create(babylon, "uuid", "startTime", "user", "jobRequest");
        UxFilterMetas filterMetas = new UxFilterMetas(new UxFilterMeta<IcCubePrintJobStatus>("user", babylon.translate("filterPrintingJobUser", new Serializable[0]), IcCubePrintJobStatus::getUserName));
        UxTableRowSearcher<IcCubePrintJobStatus> searcher = new UxTableRowSearcher<IcCubePrintJobStatus>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public boolean isAccepting(IcCubePrintJobStatus row, String searchText) {
                return this.isContaining(searchText, row.getUserName());
            }
        };
        List<IcCubePrintJobStatus> jobs = this.filter(this.tableOptions, searcher, filterMetas, service.getAllSortedActiveJobs());
        int totalRowCount = jobs.size();
        UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.createForFirstPageWithDefaults(queryContext.getApi(), totalRowCount));
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        for (IcCubePrintJobStatus job : jobs) {
            rows.add(UxPrintJobsQuery.createRow(queryContext, job));
        }
        UxTable table = UxTable.create(options, header, rows);
        List<UxTableRow> actualRows = table.getRows();
        if (actualRows != null) {
            for (UxTableRow actualRow : actualRows) {
                UxPrintJobsQuery.setupRowUseCase(queryContext, actualRow);
            }
        }
        UxTableMeta tableMeta = new UxTableMeta(searcher != null, filterMetas);
        return UxReply.success(new UxTableWithUseCasesReplyPayload(tableMeta, table));
    }

    private static UxTableRow createRow(UxQueryContext context, IcCubePrintJobStatus status) {
        ArrayList<UxTableCell> cells = new ArrayList<UxTableCell>();
        cells.add(new UxTableCell(status.getUuid()));
        cells.add(new UxTableCell(status.getStartDateServerTimeForJob()).withValue_(status.getStartDate()));
        cells.add(new UxTableCell(status.getUserName()));
        cells.add(new UxTableCell(status.getRequest()));
        UxTableRow row = new UxTableRow(cells);
        row.setData(status);
        return row;
    }

    private static void setupRowUseCase(UxQueryContext context, UxTableRow row) {
        IcCubePrintJobStatus status = (IcCubePrintJobStatus)row.getData();
        UxUseCase useCase = UxRequestQueryMeta.createUseCaseForPrintingJob(context, status.getRequest());
        row.setUseCase(useCase);
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxAdminUseCaseName.PrintJobs));
    }
}

