/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.runtime.perms;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.authorization.permissions.role.UxPermissionsDetails;
import crazydev.iccube.pub.authorization.IOlapPermissionsService;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.roles.UxAbstractRoleQuery;
import crazydev.iccube.ux.admin.queries.runtime.perms.UxPermsQueryMeta;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.table.UxPropertyTableReplyPayload;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class UxPermsQuery
extends UxAbstractRoleQuery {
    private final String uuid;
    @Nullable
    private final UxTableOptions tableOptions;
    @Nullable
    private UxPermissionsDetails perms;

    public UxPermsQuery(UxQueryMeta meta, OlapRequestId requestId, String uuid, @Nullable UxTableOptions tableOptions) {
        super(meta, requestId);
        this.uuid = uuid;
        this.tableOptions = tableOptions;
    }

    @Override
    protected UxReply doExecuteQuery(UxQueryContext queryContext) {
        IOlapPermissionsService service = queryContext.getRolePermissionsService();
        this.perms = service.getPermissionsDetailsForUX(this.uuid);
        if (this.perms == null) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.PERMS_UNKNOWN, (Serializable[])new Serializable[]{this.uuid}));
        }
        UxBabylonService babylon = queryContext.getUxBabylonService();
        boolean isForRestApi = queryContext.isForRestApi();
        UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.create());
        UxTableHeaders header = UxTableHeaders.create(babylon, "property", "value");
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "uuid"), this.perms.getUUID()));
        rows.add(UxTableRow.create(babylon.translate_(isForRestApi, "roleName"), this.perms.getRoleName()));
        rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "roleOnTheFly"), babylon.translate(this.perms.isOnTheFly() ? "yesL" : "noL", new Serializable[0])));
        String onTheFlyLastUsedS = this.perms.getOnTheFlyLastUsedS();
        if (onTheFlyLastUsedS != null) {
            rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "roleOnTheFlyLastUsed"), onTheFlyLastUsedS));
        }
        rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "roleTotalElapsedMS"), CdTimeUtils.formatMillis((long)this.perms.getTotalElapsedMS())));
        rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "roleDetailedTotalElapsedMS"), this.perms.getDetailedTotalElapsedMS()));
        rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "schemaPermsDefinition"), this.perms.getSchemaPermsDefinition()));
        rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "dashboardsPermsDefinition"), this.perms.getDashboardsPermsDefinition()));
        rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "docsPermsDefinition"), this.perms.getDocsPermsDefinition()));
        UxTable table = UxTable.create(options, header, rows);
        return UxReply.success(new UxPropertyTableReplyPayload(table));
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        boolean onTheFly = this.perms != null && this.perms.isOnTheFly();
        reply.withUseCase(UxPermsQueryMeta.createUseCase(queryContext, onTheFly, this.uuid, this.perms != null ? this.perms.getRoleName() : null));
    }
}

