/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.runtime.perms;

import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.authorization.permissions.role.UxPermissions;
import crazydev.iccube.pub.authorization.IOlapPermissionsService;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxBoolean;
import crazydev.iccube.ux.admin.queries.UxAdminQuery;
import crazydev.iccube.ux.admin.queries.runtime.perms.UxPermsQueryMeta;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.common.filter.UxEnumFilterType;
import crazydev.iccube.ux.common.filter.UxFilterMeta;
import crazydev.iccube.ux.common.filter.UxFilterMetas;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableCell;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableMeta;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.common.table.UxTableRowSearcher;
import crazydev.iccube.ux.common.table.UxTableSortType;
import crazydev.iccube.ux.common.table.UxTableWithUseCasesReplyPayload;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class UxAllPermsQuery
extends UxAdminQuery {
    @Nullable
    private final UxTableOptions tableOptions;

    protected UxAllPermsQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxTableOptions tableOptions) {
        super(meta, requestId);
        this.tableOptions = tableOptions;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        UxBabylonService babylon = queryContext.getUxBabylonService();
        UxTableHeaders header = UxTableHeaders.create(babylon, "roleName", "roleOnTheFly", "roleOnTheFlyLastUsed", "roleTotalElapsedMS");
        UxFilterMetas filterMetas = new UxFilterMetas(new UxFilterMeta<UxPermissions>("roleName", babylon.translate("filterRoleName", new Serializable[0]), UxPermissions::getRoleName), new UxFilterMeta<UxPermissions>("roleOnTheFly", babylon.translate("filterRoleOnTheFly", new Serializable[0]), UxEnumFilterType.create(babylon, UxBoolean.class), perms -> UxBoolean.from((boolean)perms.isOnTheFly())));
        UxTableRowSearcher<UxPermissions> searcher = new UxTableRowSearcher<UxPermissions>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public boolean isAccepting(UxPermissions row, String searchText) {
                return this.isContaining(searchText, row.getRoleName());
            }
        };
        IOlapPermissionsService service = queryContext.getRolePermissionsService();
        List allPerms = this.filter(this.tableOptions, searcher, filterMetas, service.getAllPermissionsForUX());
        int totalRowCount = allPerms.size();
        UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.createForFirstPageWithDefaults(queryContext.getApi(), "roleName", UxTableSortType.asc, totalRowCount));
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        for (UxPermissions perms2 : allPerms) {
            rows.add(this.createRow(queryContext, perms2));
        }
        UxTable table = UxTable.create(options, header, rows);
        UxTableMeta tableMeta = new UxTableMeta(searcher != null, filterMetas);
        return UxReply.success(new UxTableWithUseCasesReplyPayload(tableMeta, table));
    }

    private UxTableRow createRow(UxQueryContext context, UxPermissions perms) {
        UxBabylonService babylon = context.getUxBabylonService();
        ArrayList<UxTableCell> cells = new ArrayList<UxTableCell>();
        UxUseCase useCase = UxPermsQueryMeta.createUseCase(context, perms.isOnTheFly(), perms.getUUID(), perms.getRoleName());
        cells.add(new UxTableCell(perms.getRoleName()));
        cells.add(new UxTableCell(babylon.translate(perms.isOnTheFly() ? "yesL" : "noL", new Serializable[0])));
        String lastTouched = perms.getLastUsedS();
        cells.add(new UxTableCell(lastTouched != null ? lastTouched : ""));
        long elapsedMS = perms.getTotalElapsedMS();
        cells.add(new UxTableCell(CdTimeUtils.formatMillis((Locale)babylon.getLocale(), (long)elapsedMS)).withValue_(elapsedMS));
        return new UxTableRow(useCase, cells);
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxAdminUseCaseName.Perms));
    }
}

