/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.runtime.logs;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.fs.OlapFileSystem;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.UxAdminQuery;
import crazydev.iccube.ux.admin.queries.runtime.logs.UxLogFileQueryMeta;
import crazydev.iccube.ux.admin.queries.utils.UxFileUtils;
import crazydev.iccube.ux.admin.queries.utils.UxFileWrapper;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import org.jetbrains.annotations.Nullable;

public class UxLogFileQuery
extends UxAdminQuery {
    @Nullable
    private final String filePath;
    @Nullable
    private OlapFile file;

    protected UxLogFileQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String filePath) {
        super(meta, requestId);
        this.filePath = filePath;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        if (!CdStringUtils.isNullOrBlank((String)this.filePath)) {
            OlapFileSystem logRoot = queryContext.getLogRoot();
            this.file = logRoot == null ? null : logRoot.create(this.filePath);
        }
        String mimeType = "application/octet-stream";
        UxFileWrapper wrapper = UxFileWrapper.forOlapFile(this.file, this.filePath, "application/octet-stream", "log", false);
        return UxFileUtils.createFileContent(queryContext, this.meta.queryName(), wrapper);
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(UxLogFileQueryMeta.createUseCase(queryContext, this.filePath));
    }
}

