/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.runtime.logs;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.fs.OlapFileSystem;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.UxAdminQuery;
import crazydev.iccube.ux.admin.queries.utils.UxFileWrapper;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxAttachmentReply;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxDownloadLogFileQuery
extends UxAdminQuery {
    @Nullable
    private final String filePath;

    protected UxDownloadLogFileQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String filePath) {
        super(meta, requestId);
        this.filePath = filePath;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        OlapFile file = null;
        if (!CdStringUtils.isNullOrBlank((String)this.filePath)) {
            OlapFileSystem logRoot = queryContext.getLogRoot();
            OlapFile olapFile = file = logRoot == null ? null : logRoot.create(this.filePath);
        }
        if (file == null) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.FILE_NOT_FOUND, (Serializable[])new Serializable[]{this.filePath}));
        }
        UxFileWrapper wrapper = UxFileWrapper.forOlapFile(file, this.filePath, "text/plain", false);
        return new UxAttachmentReply(wrapper, null);
    }
}

