/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.runtime.audit;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.fs.CdVFileSystem;
import crazydev.common.utils.CdSizeUtils;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.fs.OlapFileSystem;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.UxAdminQuery;
import crazydev.iccube.ux.admin.queries.runtime.audit.UxAuditFileQueryMeta;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.style.UxStylePresentation;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableCell;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.common.table.UxTableSortType;
import crazydev.iccube.ux.common.table.UxTableWithUseCasesReplyPayload;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class UxAuditFilesQuery
extends UxAdminQuery {
    @Nullable
    private final UxTableOptions tableOptions;

    protected UxAuditFilesQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxTableOptions tableOptions) {
        super(meta, requestId);
        this.tableOptions = tableOptions;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        try {
            UxBabylonService babylon = queryContext.getUxBabylonService();
            UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.create("fileName", UxTableSortType.asc));
            UxTableHeaders header = UxTableHeaders.create(babylon, "fileName", "size");
            ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
            List<AuditFile> files = UxAuditFilesQuery.getAuditFiles(queryContext);
            for (AuditFile file : files) {
                rows.add(UxAuditFilesQuery.createRow(queryContext, file));
            }
            UxTable table = UxTable.create(options, header, rows);
            String useCaseAdditionalInfo = null;
            return UxReply.success(new UxTableWithUseCasesReplyPayload(table, useCaseAdditionalInfo));
        }
        catch (IOException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[UX] could not retrieve the audit files", (Throwable)ex);
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.AUDIT_FILES_ERROR, (Serializable[])new Serializable[0]));
        }
    }

    private static UxTableRow createRow(UxQueryContext context, AuditFile file) {
        UxBabylonService babylon = context.getUxBabylonService();
        ArrayList<UxTableCell> cells = new ArrayList<UxTableCell>();
        UxUseCase useCase = UxAuditFileQueryMeta.createUseCase(context, file.path);
        cells.add(new UxTableCell((Object)file.path, useCase).withStyle(UxStylePresentation.PRE));
        cells.add(new UxTableCell(CdSizeUtils.formatEx((Locale)babylon.getLocale(), (double)file.size)).withStyle(UxStylePresentation.PRE).withValue_(file.size));
        return new UxTableRow(cells);
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxAdminUseCaseName.AuditFiles));
    }

    private static List<AuditFile> getAuditFiles(UxQueryContext queryContext) throws IOException {
        ArrayList<AuditFile> paths = new ArrayList<AuditFile>();
        OlapDirectoriesResolved directories = queryContext.asRuntimeContext().getDirectoriesResolved();
        OlapFileSystem fs = OlapFileSystem.createFileSystem((CdVFileSystem)queryContext.getVfs(), (File)directories.getAuditDirectory());
        List files = fs.sortedList(1024, true);
        if (files != null) {
            for (OlapFile file : files) {
                if (file.isDirectory()) continue;
                String path = file.getPath();
                long size = file.length();
                paths.add(new AuditFile(path, size));
            }
        }
        return paths;
    }

    static class AuditFile {
        final String path;
        final long size;

        public AuditFile(String path, long size) {
            this.path = path;
            this.size = size;
        }
    }
}

