/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.runtime.audit;

import crazydev.iccube.ux.admin.queries.runtime.UxRuntimeQueryMeta;
import crazydev.iccube.ux.admin.queries.runtime.audit.UxAuditFileQuery;
import crazydev.iccube.ux.admin.queries.runtime.audit.UxAuditFilesQueryMeta;
import crazydev.iccube.ux.admin.queries.runtime.audit.UxDownloadAuditFileQueryMeta;
import crazydev.iccube.ux.admin.queries.utils.UxArrays;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseRepository;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.url.UxUrl;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.usecase.UxUseCaseBuilder;
import crazydev.iccube.ux.common.usecase.UxUseCaseTitle;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.console.queries.refresh.UxRefreshQueryMeta;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxAuditFileQueryMeta
extends UxRuntimeQueryMeta {
    public static final UxAuditFileQueryMeta AuditFile = new UxAuditFileQueryMeta();

    public UxAuditFileQueryMeta() {
        super(UxConsoleConstants.QueryName.AuditFile);
    }

    @Override
    public boolean isAuthorized(UxQueryContext context) {
        return UxAuditFilesQueryMeta.AuditFiles.isAuthorized(context);
    }

    @Override
    public List<UxAction> createActions(UxQueryContext context) {
        return UxArrays.asList(UxRefreshQueryMeta.createAction(context));
    }

    @Override
    public UxQuery parseQuery(UxServerRequestParams params) {
        String filePath = params.getStringParameter("path");
        return new UxAuditFileQuery(this, params.getRequestId(), filePath);
    }

    public UxUrl createQueryUrl(String filePath) {
        return this.createQueryUrl().addParam("path", filePath);
    }

    static UxUseCase createUseCase(UxQueryContext context, @Nullable String filePath) {
        UxBabylonService babylon = context.getUxBabylonService();
        List<UxAction> actions = null;
        if (filePath != null) {
            actions = AuditFile.createActions(context);
            actions.add(UxDownloadAuditFileQueryMeta.createAction(context, filePath));
        }
        return new UxUseCaseBuilder(context, AuditFile).withId(UxAdminUseCaseName.AuditFile.name() + "-" + filePath).withCaption(babylon.translateUseCaseCaption(UxAuditFileQueryMeta.AuditFile.queryName.name(), new Serializable[0])).withUrl(AuditFile.createQueryUrl(filePath)).withExtraTitle(new UxUseCaseTitle(context.getUseCase(UxAdminUseCaseName.AuditFiles), filePath, UxAdminUseCaseRepository.asBookmark(AuditFile.createQueryUrl(filePath)))).withActions(actions).build(true);
    }
}

