/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.roles.apps;

import crazydev.iccube.authorization.definition.application.OlapRoleApplicationDefinition;
import crazydev.iccube.authorization.definition.application.OlapRoleApplicationFeatureDefinition;
import crazydev.iccube.authorization.definition.application.OlapRoleApplicationsDefinition;
import crazydev.iccube.ux.admin.queries.roles.apps.UxAppPerms;
import crazydev.iccube.ux.admin.queries.roles.apps.UxGroupAppPerms;
import crazydev.iccube.ux.admin.queries.roles.apps.UxNodeAppPerms;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public abstract class UxAppPermsHelper {
    private UxAppPermsHelper() {
    }

    public static UxAppPerms toUxAppPerms(UxQueryContext context, OlapRoleApplicationsDefinition definition) {
        UxBabylonService babylon = context.getUxBabylonService();
        ArrayList<UxGroupAppPerms> groups = new ArrayList<UxGroupAppPerms>();
        groups.add(new UxGroupAppPerms("app.network", babylon.translate("app.network", new Serializable[0])));
        groups.add(new UxGroupAppPerms("app.ui", babylon.translate("app.ui", new Serializable[0])));
        groups.add(new UxGroupAppPerms("app.web.reporting", babylon.translate("app.web.reporting", new Serializable[0])));
        List permissions = definition.getPermissionsForUX();
        if (permissions != null) {
            for (OlapRoleApplicationDefinition perms : permissions) {
                String id = perms.getName();
                String caption = babylon.translate(id, new Serializable[0]);
                UxNodeAppPerms node = new UxNodeAppPerms(id, caption);
                node.setChildrenSingleSelection(perms.isSingleSelectionFeature());
                UxGroupAppPerms group = UxAppPermsHelper.group(groups, perms.getGroupLocalizationTag());
                List features = perms.getFeatures();
                if (features != null) {
                    for (OlapRoleApplicationFeatureDefinition feature : features) {
                        String featureId = feature.getName();
                        if (featureId == null) continue;
                        String featureCaption = babylon.translate(featureId, new Serializable[0]);
                        boolean featureChecked = feature.isEnabled();
                        if (featureChecked) {
                            node.setChecked(true);
                        }
                        if (features.size() == 1) continue;
                        UxNodeAppPerms child = new UxNodeAppPerms(featureId, featureCaption);
                        child.setChecked(featureChecked);
                        node.addChildren(child);
                    }
                }
                group.addNode(node);
            }
        }
        UxAppPermsHelper.sort(context, (UxGroupAppPerms)groups.get(2));
        return new UxAppPerms(groups);
    }

    private static void sort(UxQueryContext context, UxGroupAppPerms group) {
        int order = 3;
        block12: for (UxNodeAppPerms node : group.getNodes()) {
            switch (node.getId()) {
                case "app.reportDashboard": {
                    node.setOrder(0);
                    continue block12;
                }
                case "app.reportDashboardApplication": {
                    node.setOrder(1);
                    continue block12;
                }
                case "app.reportGadget": {
                    node.setOrder(2);
                    continue block12;
                }
                case "app.reportDashboardDataSources": {
                    node.setOrder(3);
                    continue block12;
                }
            }
            node.setOrder(order++);
            node.setHidden(true);
        }
        group.sortNodes(Comparator.comparingInt(UxNodeAppPerms::getOrder));
    }

    private static UxGroupAppPerms group(List<UxGroupAppPerms> groups, String id) {
        for (UxGroupAppPerms group : groups) {
            if (!id.equals(group.getId())) continue;
            return group;
        }
        throw new RuntimeException("unexpected application group [" + id + "]");
    }

    public static OlapRoleApplicationsDefinition toDefinition(UxAppPerms perms) {
        ArrayList<OlapRoleApplicationDefinition> apps = new ArrayList<OlapRoleApplicationDefinition>();
        for (UxGroupAppPerms group : perms.getGroups()) {
            for (UxNodeAppPerms node : group.getNodes()) {
                apps.add(UxAppPermsHelper.toDefinition(node));
            }
        }
        return new OlapRoleApplicationsDefinition(apps);
    }

    private static OlapRoleApplicationDefinition toDefinition(UxNodeAppPerms app) {
        String appName = app.getId();
        boolean appEnabled = app.isChecked();
        ArrayList<OlapRoleApplicationFeatureDefinition> features = new ArrayList<OlapRoleApplicationFeatureDefinition>();
        for (UxNodeAppPerms child : app.getChildren()) {
            String featureName = child.getId();
            boolean featureEnabled = child.isChecked();
            features.add(new OlapRoleApplicationFeatureDefinition(featureName, featureEnabled));
        }
        OlapRoleApplicationDefinition definition = OlapRoleApplicationsDefinition.fromName((String)appName, features);
        if (features.isEmpty()) {
            if (appEnabled) {
                return definition.createAsEnabled();
            }
            return definition.createAsDisabled();
        }
        return definition;
    }
}

