/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.roles;

import crazydev.iccube.authorization.definition.role.IOlapRoleDefinition;
import crazydev.iccube.authorizationx.flat.definition.dashboards.OlapRoleFlatDashboardsProfile;
import crazydev.iccube.authorizationx.flat.definition.docs.OlapRoleFlatDocsProfile;
import crazydev.iccube.pub.authorization.IOlapPermissionsService;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.roles.UxAbstractRoleQuery;
import crazydev.iccube.ux.admin.queries.roles.UxRoleQueryMeta;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.common.filter.UxFilterMeta;
import crazydev.iccube.ux.common.filter.UxFilterMetas;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.style.UxStyleLevel;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableCell;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableMeta;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.common.table.UxTableRowSearcher;
import crazydev.iccube.ux.common.table.UxTableSortType;
import crazydev.iccube.ux.common.table.UxTableWithUseCasesReplyPayload;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class UxRolesQuery
extends UxAbstractRoleQuery {
    @Nullable
    private final UxTableOptions tableOptions;

    public UxRolesQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxTableOptions tableOptions) {
        super(meta, requestId);
        this.tableOptions = tableOptions;
    }

    @Override
    protected UxReply doExecuteQuery(UxQueryContext queryContext) {
        UxBabylonService babylon = queryContext.getUxBabylonService();
        UxTableHeaders header = UxTableHeaders.create(babylon, "name", "description", "status");
        UxFilterMetas filterMetas = new UxFilterMetas(new UxFilterMeta<IOlapRoleDefinition>("name", babylon.translate("filterRoleName", new Serializable[0]), IOlapRoleDefinition::getName), new UxFilterMeta<IOlapRoleDefinition>("description", babylon.translate("filterRoleDescription", new Serializable[0]), IOlapRoleDefinition::getDescription));
        UxTableRowSearcher<IOlapRoleDefinition> searcher = new UxTableRowSearcher<IOlapRoleDefinition>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public boolean isAccepting(IOlapRoleDefinition row, String searchText) {
                return this.isContaining(searchText, row.getName());
            }
        };
        IOlapPermissionsService service = queryContext.getRolePermissionsService();
        List roles = this.filter(this.tableOptions, searcher, filterMetas, service.getAllRoleDefinitionsForUX(false, false));
        int totalRowCount = roles.size();
        UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.createForFirstPageWithDefaults(queryContext.getApi(), "name", UxTableSortType.asc, totalRowCount));
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        for (IOlapRoleDefinition role : roles) {
            rows.add(this.createRow(queryContext, role));
        }
        UxTable table = UxTable.create(options, header, rows);
        UxTableMeta tableMeta = new UxTableMeta(searcher != null, filterMetas);
        return UxReply.success(new UxTableWithUseCasesReplyPayload(tableMeta, table));
    }

    private UxTableRow createRow(UxQueryContext context, IOlapRoleDefinition role) {
        UxBabylonService babylon = context.getUxBabylonService();
        ArrayList<UxTableCell> cells = new ArrayList<UxTableCell>();
        UxUseCase useCase = UxRoleQueryMeta.createUseCase(context, role.getUUID(), role.getName());
        cells.add(new UxTableCell((Object)role.getName(), useCase));
        cells.add(new UxTableCell(role.getDescription()));
        UxStyleLevel rowStyle = null;
        OlapRoleFlatDashboardsProfile dashboards = role.getValidatedDashboardsPermissions();
        if (dashboards.isOnError()) {
            cells.add(new UxTableCell(babylon.translate("roleDashboardsOnError", new Serializable[0])));
            rowStyle = UxStyleLevel.ERROR;
        } else {
            OlapRoleFlatDocsProfile docs = role.getValidatedDocsPermissions();
            if (docs != null && docs.isOnError()) {
                cells.add(new UxTableCell(babylon.translate("roleDocsOnError", new Serializable[0])));
                rowStyle = UxStyleLevel.ERROR;
            } else {
                cells.add(new UxTableCell(""));
            }
        }
        return new UxTableRow(cells).withStyle(rowStyle);
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxAdminUseCaseName.Roles));
    }
}

