/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.roles;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.fs.CdVFileSystem;
import crazydev.common.fs.revision.CdVFileRevAction;
import crazydev.common.fs.revision.CdVFileRevActionOperation;
import crazydev.common.fs.revision.CdVFileRevHelperConf;
import crazydev.common.fs.revision.CdVFileRevManagerKind;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.xml.CdXmlUtils;
import crazydev.iccube.authorization.definition.role.OlapRoleDefinition;
import crazydev.iccube.authorization.definition.role.OlapRoleDefinitions;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.contextual.OlapContextualBigException;
import crazydev.iccube.contextual.OlapContextualError;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.authorization.IOlapPermissionsService;
import crazydev.iccube.ux.admin.queries.roles.UxRolesException;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.validation.UxValidationMessage;
import crazydev.iccube.ux.common.validation.UxValidationResult;
import crazydev.iccube.ux.processor.UxBabylonService;
import jakarta.xml.bind.JAXBException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public abstract class UxRolesHelper {
    private static final Object LOCK = new Object();

    private UxRolesHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static UxValidationResult saveRoleDefinition(UxQueryContext context, OlapRoleDefinition role, int revNumber) {
        Object object = LOCK;
        synchronized (object) {
            return UxRolesHelper.saveRoleDefinitionUnsafe(context, role, revNumber);
        }
    }

    @Nullable
    private static UxValidationResult saveRoleDefinitionUnsafe(UxQueryContext context, OlapRoleDefinition role, int revNumber) {
        OlapRoleDefinitions definitions;
        UxBabylonService babylon = context.getUxBabylonService();
        OlapDirectoriesResolved directories = context.getResolvedDirectories();
        File xml = new File(directories.getRolesDirectory(), "icCubeRoles.icc-roles");
        try {
            definitions = UxRolesHelper.unmarshallRoleDefinitions(context, xml);
        }
        catch (UxRolesException ex) {
            return new UxValidationResult(new UxValidationMessage("ERROR", babylon.translate("roleDefsError", new Serializable[]{ex.getMessage()})));
        }
        UxValidationResult error = UxRolesHelper.saveOrUpdateRole(context, definitions, role, revNumber);
        if (error != null) {
            return error;
        }
        try {
            String info = role.getName();
            if (CdStringUtils.isNullOrBlank((String)info)) {
                info = role.getUUID();
            }
            UxRolesHelper.marshallRoleDefinitions(context, "add-or-update " + info, definitions);
        }
        catch (JAXBException | IOException | RuntimeException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[roles] could not save roles definitions (/SaveRole)", ex);
            return new UxValidationResult(new UxValidationMessage("ERROR", babylon.translate("roleDefsError", new Serializable[]{babylon.translate("roleDefsError_persist", new Serializable[]{ex.getMessage()})})));
        }
        try {
            IOlapPermissionsService service = context.getRolePermissionsService();
            service.applyPermissions(context.getOlapEngineRequestContext(), definitions);
        }
        catch (OlapContextualBigException ex) {
            return UxRolesHelper.onPermissionsServiceException(context, ex);
        }
        return null;
    }

    @Nullable
    private static UxValidationResult saveOrUpdateRole(UxQueryContext context, OlapRoleDefinitions definitions, OlapRoleDefinition role, int revNumber) {
        UxBabylonService babylon = context.getUxBabylonService();
        IOlapPermissionsService service = context.getRolePermissionsService();
        int currentRevNumber = service.getRevisionNumber();
        if (currentRevNumber != revNumber) {
            return new UxValidationResult(new UxValidationMessage("ERROR", UxErrorCode.ROLES_REV_NUMBER_MISMATCH.asMessage(babylon, new Serializable[]{Integer.valueOf(currentRevNumber), Integer.valueOf(revNumber)})));
        }
        if (CdStringUtils.isNullOrBlank((String)role.getUUID())) {
            return new UxValidationResult(new UxValidationMessage("ERROR", UxErrorCode.ROLE_MISSING_UUID.asMessage(babylon, new Serializable[0])));
        }
        if (CdStringUtils.isNullOrBlank((String)role.getName())) {
            return new UxValidationResult(new UxValidationMessage("ERROR", UxErrorCode.ROLE_MISSING_NAME.asMessage(babylon, new Serializable[0])));
        }
        OlapRoleDefinition existingRole = UxRolesHelper.getRoleDefinitionByUUID(definitions, role.getUUID());
        if (existingRole == null) {
            if (UxRolesHelper.getRoleDefinitionByName(definitions, role.getName()) != null) {
                return new UxValidationResult(new UxValidationMessage("ERROR", UxErrorCode.ROLE_DUPLICATED.asMessage(babylon, new Serializable[]{role.getName()})));
            }
            definitions.addRoleDefinition(role);
        } else {
            if (!role.getName().equals(existingRole.getName()) && UxRolesHelper.getRoleDefinitionByName(definitions, role.getName()) != null) {
                return new UxValidationResult(new UxValidationMessage("ERROR", UxErrorCode.ROLE_DUPLICATED.asMessage(babylon, new Serializable[]{role.getName()})));
            }
            definitions.replaceRoleDefinition(role);
        }
        UxValidationResult error = UxRolesHelper.validate(context, definitions, role);
        if (error != null) {
            return error;
        }
        return null;
    }

    @Nullable
    private static UxValidationResult validate(UxQueryContext context, OlapRoleDefinitions roles, OlapRoleDefinition role) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static UxValidationResult deleteRoleDefinition(UxQueryContext context, String uuid) {
        Object object = LOCK;
        synchronized (object) {
            return UxRolesHelper.deleteRoleDefinitionUnsafe(context, uuid);
        }
    }

    @Nullable
    private static UxValidationResult deleteRoleDefinitionUnsafe(UxQueryContext context, String uuid) {
        OlapRoleDefinitions definitions;
        UxBabylonService babylon = context.getUxBabylonService();
        OlapDirectoriesResolved directories = context.getResolvedDirectories();
        File xml = new File(directories.getRolesDirectory(), "icCubeRoles.icc-roles");
        try {
            definitions = UxRolesHelper.unmarshallRoleDefinitions(context, xml);
        }
        catch (UxRolesException ex) {
            return new UxValidationResult(new UxValidationMessage("ERROR", babylon.translate("roleDefsError", new Serializable[]{ex.getMessage()})));
        }
        OlapRoleDefinition status = UxRolesHelper.deleteRole(context, definitions, uuid);
        if (status == null) {
            return null;
        }
        try {
            String operation = "delete role " + (status.getName() != null ? status.getName() : uuid);
            UxRolesHelper.marshallRoleDefinitions(context, operation, definitions);
        }
        catch (JAXBException | IOException | RuntimeException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[roles] could not save roles definitions (/DeleteRole)", ex);
            return new UxValidationResult(new UxValidationMessage("ERROR", babylon.translate("roleDefsError", new Serializable[]{babylon.translate("roleDefsError_persist", new Serializable[]{ex.getMessage()})})));
        }
        try {
            IOlapPermissionsService service = context.getRolePermissionsService();
            service.applyPermissions(context.getOlapEngineRequestContext(), definitions);
        }
        catch (OlapContextualBigException ex) {
            return UxRolesHelper.onPermissionsServiceException(context, ex);
        }
        return null;
    }

    private static OlapRoleDefinition deleteRole(UxQueryContext context, OlapRoleDefinitions definitions, String uuid) {
        OlapRoleDefinition toRemove;
        List roleDefinitions = definitions.getRoleDefinitions();
        if (roleDefinitions != null && (toRemove = UxRolesHelper.getRoleDefinitionByUUID(definitions, uuid)) != null) {
            if (roleDefinitions.remove(toRemove)) {
                return toRemove;
            }
            return null;
        }
        return null;
    }

    private static void marshallRoleDefinitions(UxQueryContext context, String operation, OlapRoleDefinitions definitions) throws JAXBException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));){
            CdXmlUtils.marshall((Writer)writer, (Object)definitions, (Class[])new Class[]{OlapRoleDefinitions.class});
        }
        OlapDirectoriesResolved directories = context.getResolvedDirectories();
        File dest = new File(directories.getRolesDirectory(), "icCubeRoles.icc-roles");
        try (BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(out.toByteArray()));){
            CdVFileRevActionOperation action = new CdVFileRevActionOperation(context.getUserName(), operation);
            CdVFileSystem vfs = directories.getVfs();
            CdVFileRevHelperConf configuration = new CdVFileRevHelperConf(CdVFileRevManagerKind.ROLES, directories.getTmpDirectory(), directories.getRolesDirectory());
            vfs.saveOrUpdateWithRevision(configuration, dest, (InputStream)in, (CdVFileRevAction)action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void applyRoleDefinitions(UxQueryContext context, InputStream in, String operation) throws UxRolesException {
        Object object = LOCK;
        synchronized (object) {
            UxRolesHelper.applyRoleDefinitionsUnsafe(context, in, operation);
        }
    }

    private static void applyRoleDefinitionsUnsafe(UxQueryContext context, InputStream in, String operation) throws UxRolesException {
        OlapRoleDefinitions roles;
        String content;
        UxBabylonService babylon = context.getUxBabylonService();
        try {
            content = IOUtils.toString((InputStream)in, (String)"UTF-8");
            roles = (OlapRoleDefinitions)CdXmlUtils.unmarshall((String)content, (Class[])new Class[]{OlapRoleDefinitions.class});
        }
        catch (IOException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"roles definition IO error", (Throwable)ex);
            throw UxRolesException.create(babylon, babylon.translate("roleDefsError_io", new Serializable[]{ex.getMessage()}), ex);
        }
        catch (JAXBException | RuntimeException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"invalid XML roles definitions", ex);
            throw UxRolesException.create(babylon, babylon.translate("roleDefsError_xml", new Serializable[0]));
        }
        OlapDirectoriesResolved directories = context.getResolvedDirectories();
        File dest = new File(directories.getRolesDirectory(), "icCubeRoles.icc-roles");
        try (ByteArrayInputStream in_ = new ByteArrayInputStream(content.getBytes("UTF-8"));){
            CdVFileRevActionOperation action = new CdVFileRevActionOperation(context.getUserName(), operation);
            CdVFileSystem vfs = directories.getVfs();
            CdVFileRevHelperConf configuration = new CdVFileRevHelperConf(CdVFileRevManagerKind.ROLES, directories.getTmpDirectory(), directories.getRolesDirectory());
            vfs.saveOrUpdateWithRevision(configuration, dest, (InputStream)in_, (CdVFileRevAction)action);
        }
        catch (IOException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[roles] could not persist roles definitions", (Throwable)ex);
            throw UxRolesException.create(babylon, babylon.translate("roleDefsError_persist", new Serializable[]{ex.getMessage()}));
        }
        try {
            IOlapPermissionsService service = context.getRolePermissionsService();
            service.applyPermissions(context.getOlapEngineRequestContext(), roles);
        }
        catch (OlapContextualBigException ex) {
            UxRolesHelper.onPermissionsServiceException(context, ex);
            throw UxRolesException.create(babylon, babylon.translate("roleDefsError_refresh", new Serializable[0]));
        }
    }

    private static UxValidationResult onPermissionsServiceException(UxQueryContext context, OlapContextualBigException ex) {
        OlapLoggers.UX_REQUEST.error((Object)"[roles] permissions service setup error(s)", (Throwable)ex);
        ArrayList<UxValidationMessage> messages = new ArrayList<UxValidationMessage>();
        List errors = ex.getErrors();
        for (OlapContextualError error : errors) {
            OlapLoggers.UX_REQUEST.error((Object)("[roles] - " + String.valueOf(error)));
            String message = error.asFullMessage((CdBabylonService)OlapBabylonService.ENGLISH);
            messages.add(new UxValidationMessage("ERROR", message));
        }
        return new UxValidationResult(messages);
    }

    /*
     * Loose catch block
     */
    private static OlapRoleDefinitions unmarshallRoleDefinitions(UxQueryContext context, File xmlFile) throws UxRolesException {
        UxBabylonService babylon = context.getUxBabylonService();
        BufferedReader reader = null;
        String content = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(xmlFile), "UTF-8"));
            content = IOUtils.toString((Reader)reader);
        }
        catch (IOException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"roles definition IO error", (Throwable)ex);
            throw UxRolesException.create(babylon, babylon.translate("roleDefsError_io", new Serializable[]{ex.getMessage()}), ex);
        }
        OlapRoleDefinitions ex = (OlapRoleDefinitions)CdXmlUtils.unmarshall((String)content, (Class[])new Class[]{OlapRoleDefinitions.class});
        IOUtils.closeQuietly((Reader)reader);
        return ex;
        {
            catch (JAXBException | RuntimeException ex2) {
                try {
                    OlapLoggers.UX_REQUEST.error((Object)"invalid XML roles definitions", ex2);
                    throw UxRolesException.create(babylon, babylon.translate("roleDefsError_xml", new Serializable[0]));
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
            }
        }
    }

    @Nullable
    private static OlapRoleDefinition getRoleDefinitionByUUID(OlapRoleDefinitions definitions, String uuid) {
        List roleDefinitions = definitions.getRoleDefinitions();
        if (uuid == null || roleDefinitions == null) {
            return null;
        }
        for (OlapRoleDefinition roleDefinition : roleDefinitions) {
            if (!uuid.equals(roleDefinition.getUUID())) continue;
            return roleDefinition;
        }
        return null;
    }

    @Nullable
    private static OlapRoleDefinition getRoleDefinitionByName(OlapRoleDefinitions definitions, String name) {
        List roleDefinitions = definitions.getRoleDefinitions();
        if (name == null || roleDefinitions == null) {
            return null;
        }
        for (OlapRoleDefinition roleDefinition : roleDefinitions) {
            String roleDefinitionName = roleDefinition.getName();
            if (roleDefinitionName == null || !roleDefinitionName.equals(name)) continue;
            return roleDefinition;
        }
        return null;
    }
}

