/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.roles;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.fs.CdVFileSystem;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.fs.OlapFileSystem;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.roles.UxAbstractRoleQuery;
import crazydev.iccube.ux.admin.queries.utils.UxFileWrapper;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxAttachmentReply;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.File;
import java.io.Serializable;

public class UxDownloadRolesFileQuery
extends UxAbstractRoleQuery {
    public UxDownloadRolesFileQuery(UxQueryMeta meta, OlapRequestId requestId) {
        super(meta, requestId);
    }

    @Override
    protected UxReply doExecuteQuery(UxQueryContext queryContext) {
        OlapDirectoriesResolved directories = queryContext.getResolvedDirectories();
        File roles = directories.getRolesDirectory();
        OlapFileSystem fs = OlapFileSystem.createFileSystem((CdVFileSystem)directories.getVfs(), (File)roles);
        OlapFile file = fs.create("icCubeRoles.icc-roles");
        if (!file.exists()) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.FILE_NOT_FOUND, (Serializable[])new Serializable[]{file.getName()}));
        }
        String mimeType = queryContext.getMimeTypeByExtension(file.getName());
        UxFileWrapper wrapper = UxFileWrapper.forOlapFile(file, file.getName(), mimeType, false);
        return new UxAttachmentReply(wrapper, null);
    }
}

