/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.plugins;

import crazydev.iccube.ux.admin.queries.UxAdminQueryMeta;
import crazydev.iccube.ux.admin.queries.plugins.UxPluginQuery;
import crazydev.iccube.ux.admin.queries.plugins.UxPluginsQueryMeta;
import crazydev.iccube.ux.admin.queries.utils.UxArrays;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseRepository;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.url.UxUrl;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.usecase.UxUseCaseBuilder;
import crazydev.iccube.ux.common.usecase.UxUseCaseTitle;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxPluginQueryMeta
extends UxAdminQueryMeta {
    public static final UxPluginQueryMeta Plugin = new UxPluginQueryMeta();

    public UxPluginQueryMeta() {
        super(UxConsoleConstants.QueryName.Plugin);
    }

    @Override
    public boolean isAuthorized(UxQueryContext context) {
        return UxPluginsQueryMeta.Plugins.isAuthorized(context);
    }

    @Override
    public List<UxAction> createActions(UxQueryContext context) {
        return UxArrays.asList(new UxAction[0]);
    }

    @Override
    public UxQuery parseQuery(UxServerRequestParams params) throws UxQueryParserException {
        String pluginName = params.getStringParameter("name");
        UxTableOptions tableOptions = params.getTableOptions();
        return new UxPluginQuery(this, params.getRequestId(), pluginName, tableOptions);
    }

    public UxUrl createQueryUrl(String pluginName) {
        return this.createQueryUrl().addParam("name", pluginName);
    }

    public static UxUseCase createUseCase(UxQueryContext context, @Nullable String pluginName) {
        UxBabylonService babylon = context.getUxBabylonService();
        return new UxUseCaseBuilder(context, Plugin).withId(UxAdminUseCaseName.Plugin.name() + "-" + pluginName).withCaption(babylon.translateUseCaseCaption(UxAdminUseCaseName.Plugin.name(), new Serializable[0])).withUrl(Plugin.createQueryUrl(pluginName)).withExtraTitle(new UxUseCaseTitle(context.getUseCase(UxAdminUseCaseName.Plugins), pluginName, UxAdminUseCaseRepository.asBookmark(Plugin.createQueryUrl(pluginName)))).build(true);
    }
}

