/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.plugins;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.plugins.OlapEngineAllPluginsInfo;
import crazydev.iccube.olap.component.plugins.OlapEnginePluginInfo;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.method.OlapModuleMethodCallInstrFactory;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.UxAdminQuery;
import crazydev.iccube.ux.admin.queries.plugins.UxPluginQueryMeta;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.style.UxStyleLevel;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableReplyPayload;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxPluginQuery
extends UxAdminQuery {
    @Nullable
    private final String pluginName;
    @Nullable
    private final UxTableOptions tableOptions;
    @Nullable
    private OlapEnginePluginInfo plugin;
    @Nullable
    private List<CdError> pluginErrors;

    protected UxPluginQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String pluginName, @Nullable UxTableOptions tableOptions) {
        super(meta, requestId);
        this.pluginName = pluginName;
        this.tableOptions = tableOptions;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        if (!CdStringUtils.isNullOrBlank((String)this.pluginName)) {
            OlapEngineComponent engine = queryContext.getOlapEngineComponent();
            OlapEngineAllPluginsInfo plugins = engine.getAllPluginsInfo();
            this.plugin = plugins.lookupPlugin(this.pluginName);
            if (this.plugin != null) {
                this.pluginErrors = plugins.getErrors(this.plugin.getLocation());
            }
        }
        if (this.plugin == null) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.PLUGIN_UNKNOWN, (Serializable[])new Serializable[]{this.pluginName}));
        }
        UxBabylonService babylon = queryContext.getUxBabylonService();
        UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.create());
        UxTableHeaders header = UxTableHeaders.create(babylon, "property", "value");
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        rows.add(UxTableRow.createAsPreValue("Name", this.pluginName));
        rows.add(UxTableRow.createAsPreValue("Container", this.plugin.getLocation().getName()));
        rows.add(UxTableRow.createAsPreValue("Location", this.plugin.getLocation().getAbsolutePath()));
        if (this.pluginErrors != null) {
            for (CdError error : this.pluginErrors) {
                rows.add(UxTableRow.createAsPreValue("Error", error.asMessage((CdBabylonService)queryContext.getOlapBabylonService())).withStyle(UxStyleLevel.ERROR));
            }
        }
        for (Object clazz : this.plugin.getRegisteredTableAggregators()) {
            rows.add(UxTableRow.createAsPreValue("Table Aggregator", clazz.getUxInfo()));
        }
        for (Object clazz : this.plugin.getRegisteredAuthenticationClasses()) {
            rows.add(UxTableRow.createAsPreValue("Authentication Class", ((Class)clazz).getName()));
        }
        for (Object clazz : this.plugin.getRegisteredBuilderClasses()) {
            rows.add(UxTableRow.createAsPreValue("Schema Builder Class", ((Class)clazz).getName()));
        }
        for (OlapModuleMethodCallInstrFactory methods : this.plugin.getRegisteredModuleMethods()) {
            rows.add(UxTableRow.createAsPreValue("Method Module Name", methods.getModuleName()));
        }
        for (OlapFunction function : this.plugin.getRegisteredFunctions()) {
            String functionName = function.getName();
            if (functionName.contains("!")) continue;
            rows.add(UxTableRow.createAsPreValue("Function", functionName));
        }
        UxTable table = UxTable.create(options, header, rows);
        File pluginDirectory = this.plugin.getLocation();
        String useCaseAdditionalInfo = pluginDirectory.getAbsolutePath();
        return UxReply.success(new UxTableReplyPayload(table, useCaseAdditionalInfo));
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(UxPluginQueryMeta.createUseCase(queryContext, this.pluginName));
    }
}

