/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.docs.restapi;

import crazydev.common.olap.OlapEntityType;
import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorException;
import crazydev.iccube.gwt.server.reporting.repository.IOlapDocsRequestContext;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsRepository;
import crazydev.iccube.gwt.server.reporting.repository.gizmos.OlapDocsGizmoEntityType;
import crazydev.iccube.gwt.server.reporting.repository.gizmos.OlapDocsGizmoName;
import crazydev.iccube.gwt.server.reporting.repository.gizmos.OlapDocsGizmosRepository;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.docs.UxAbstractDocsQuery;
import crazydev.iccube.ux.admin.queries.docs.UxDocsRepositoryType;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.reply.payload.UxReplyPayload;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxDocsListGizmosQuery
extends UxAbstractDocsQuery {
    private final OlapDocsGizmoEntityType type;
    private final String path;
    private final boolean all;
    private final boolean noFolder;

    public UxDocsListGizmosQuery(UxQueryMeta meta, OlapRequestId requestId, OlapDocsGizmoEntityType type, String path, boolean all, boolean noFolder) {
        super(meta, requestId);
        this.type = type;
        this.path = path;
        this.all = all;
        this.noFolder = noFolder;
    }

    @Override
    protected UxReply doExecuteQuery(UxQueryContext queryContext) throws OlapDocsErrorException {
        List<OlapDocsGizmoName> names;
        IOlapDocsRequestContext repositoryContext = queryContext.createDocsRequestContext(null, true);
        Object repository = queryContext.getDocsRepository(UxDocsRepositoryType.WEB_DOCS);
        OlapDocsGizmosRepository gizmos = ((OlapDocsRepository)repository).asGizmosRepository(this.type);
        OlapPath sPath = ((OlapDocsRepository)repository).fromLogicalSimplePath(repositoryContext, this.path);
        boolean isMyDrive = ((OlapDocsRepository)repository).isLogicalMyDriveSimplePath(repositoryContext, this.path);
        OlapDocsGizmoName namesR = gizmos.listGizmoNames(repositoryContext, this.all, sPath, false);
        List<OlapDocsGizmoName> list = names = namesR.children != null ? namesR.children : new ArrayList<OlapDocsGizmoName>();
        if (this.noFolder) {
            names = this.removeFolders(names);
        }
        OlapDocsGizmoName.sort(names);
        ArrayList<Gizmo> result = new ArrayList<Gizmo>();
        for (OlapDocsGizmoName name : names) {
            result.add(this.toGizmo((OlapDocsRepository)repository, repositoryContext, isMyDrive, name));
        }
        return UxReply.success(new Gizmos(result));
    }

    private List<OlapDocsGizmoName> removeFolders(List<OlapDocsGizmoName> names) {
        ArrayList<OlapDocsGizmoName> files = new ArrayList<OlapDocsGizmoName>();
        this.extractFiles(files, names);
        return files;
    }

    private void extractFiles(List<OlapDocsGizmoName> files, List<OlapDocsGizmoName> gizmos) {
        for (OlapDocsGizmoName gizmo : gizmos) {
            if (gizmo.type.equals(OlapEntityType.REPORT.getShortName())) {
                files.add(gizmo);
                continue;
            }
            if (gizmo.children == null) continue;
            this.extractFiles(files, gizmo.children);
        }
    }

    private Gizmo toGizmo(OlapDocsRepository repository, IOlapDocsRequestContext repositoryContext, boolean isMyDrive, OlapDocsGizmoName name) {
        if (name.isFile()) {
            return new Gizmo(GizmoKind.FILE, name.name, repository.toLogicalSimplePath(repositoryContext, isMyDrive, name.path));
        }
        Gizmo folder = new Gizmo(GizmoKind.FOLDER, name.name, repository.toLogicalSimplePath(repositoryContext, isMyDrive, name.path));
        if (name.children != null && !name.children.isEmpty()) {
            for (OlapDocsGizmoName cName : name.children) {
                folder.add(this.toGizmo(repository, repositoryContext, isMyDrive, cName));
            }
        }
        return folder;
    }

    private static class Gizmo {
        @Nullable
        private final GizmoKind kind;
        private final String name;
        private final String path;
        @Nullable
        private List<Gizmo> children;

        public Gizmo(GizmoKind kind, String name, String path) {
            this.kind = kind;
            this.name = name;
            this.path = path;
        }

        public void add(Gizmo child) {
            if (this.children == null) {
                this.children = new ArrayList<Gizmo>();
            }
            this.children.add(child);
        }
    }

    private static class Gizmos
    extends UxReplyPayload {
        private final List<Gizmo> gizmos;

        public Gizmos(List<Gizmo> gizmos) {
            this.gizmos = gizmos;
        }
    }

    private static enum GizmoKind {
        FOLDER,
        FILE;

    }
}

