/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.docs;

import crazydev.common.babylon.CdBabylonService;
import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorException;
import crazydev.iccube.gwt.server.reporting.repository.IOlapDocsRequestContext;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsRepository;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.ux.admin.queries.docs.UxDocsRepositoryType;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.common.reply.UxFileUploadReply;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;

public abstract class UxDocsHelper {
    private UxDocsHelper() {
    }

    public static UxFileUploadReply upload(UxQueryContext context, UxServerRequestParams params, String fileName) {
        try {
            UxDocsRepositoryType repositoryType = params.getEnumParameter(UxDocsRepositoryType.class, "repository");
            OlapPath path = OlapPath.createFromSimplePath((String)params.getStringParameter("path"));
            boolean overwrite = true;
            boolean expandZIP = params.getBooleanParameter("expandZIP");
            return UxDocsHelper.upload(context, params, repositoryType, path, fileName, true, expandZIP);
        }
        catch (UxQueryParserException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[UX] upload file error", (Throwable)((Object)ex));
            return UxFileUploadReply.error(ex.getError().asMessage((CdBabylonService)context.getOlapBabylonService()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UxFileUploadReply upload(UxQueryContext context, UxServerRequestParams params, UxDocsRepositoryType repositoryType, OlapPath path, String fileName, boolean overwrite, boolean expandZIP) {
        UxBabylonService babylon = context.getUxBabylonService();
        Object repository = context.getDocsRepository(repositoryType);
        IOlapDocsRequestContext docsContext = context.createDocsRequestContext();
        File tmpDirectory = context.getTmpDirectory();
        InputStream in = null;
        try {
            in = params.getInputStream();
            ((OlapDocsRepository)repository).upload(docsContext, tmpDirectory, path, in, fileName, overwrite, expandZIP);
            UxFileUploadReply uxFileUploadReply = UxFileUploadReply.success();
            return uxFileUploadReply;
        }
        catch (IOException ex) {
            OlapLoggers.UX_REQUEST.error((Object)("[UX] upload file [" + fileName + "] error"), (Throwable)ex);
            String message = babylon.translate("uploadFileError", new Serializable[]{ex.getLocalizedMessage()});
            UxFileUploadReply uxFileUploadReply = UxFileUploadReply.error(message);
            return uxFileUploadReply;
        }
        catch (OlapDocsErrorException ex) {
            OlapLoggers.UX_REQUEST.error((Object)("[UX] upload file [" + fileName + "] error"), (Throwable)((Object)ex));
            UxFileUploadReply uxFileUploadReply = UxFileUploadReply.error(ex.getError().asMessage((CdBabylonService)context.getOlapBabylonService()));
            return uxFileUploadReply;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }
}

