/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.docs;

import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.fs.OlapPathEntry;
import crazydev.iccube.ux.UxSerializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxDocsEntryPath
implements UxSerializable {
    private final List<String> names;

    private UxDocsEntryPath(List<String> names) {
        this.names = names;
    }

    public static UxDocsEntryPath fromNames(@Nullable List<String> names) {
        if (names == null) {
            return new UxDocsEntryPath(new ArrayList<String>());
        }
        return new UxDocsEntryPath(names);
    }

    public static UxDocsEntryPath fromOlapPath(OlapPath path) {
        ArrayList<String> names = new ArrayList<String>();
        for (OlapPathEntry entry : path.getEntries()) {
            names.add(entry.getName());
        }
        return new UxDocsEntryPath(names);
    }

    public boolean isEmpty() {
        return this.names == null || this.names.isEmpty();
    }

    public List<String> getNames() {
        return this.names;
    }

    public String getName() {
        return !this.names.isEmpty() ? this.names.get(this.names.size() - 1) : "";
    }

    public OlapPath toOlapPath() {
        if (this.names.isEmpty()) {
            return OlapPath.ROOT;
        }
        ArrayList<OlapPathEntry> entries = new ArrayList<OlapPathEntry>();
        for (String name : this.names) {
            entries.add(OlapPathEntry.create((String)name));
        }
        return OlapPath.create(entries);
    }

    public OlapPath toOlapPath(int last) {
        if (this.names.isEmpty()) {
            return OlapPath.ROOT;
        }
        ArrayList<OlapPathEntry> entries = new ArrayList<OlapPathEntry>();
        for (int ii = 0; ii <= last && ii < this.names.size(); ++ii) {
            entries.add(OlapPathEntry.create((String)this.names.get(ii)));
        }
        return OlapPath.create(entries);
    }

    public static String toString(@Nullable UxDocsEntryPath path) {
        return path != null ? path.toString() : "/";
    }

    public String toString() {
        if (this.names.isEmpty()) {
            return "/";
        }
        StringBuilder sb = new StringBuilder();
        for (String name : this.names) {
            sb.append("/").append(name);
        }
        return sb.toString();
    }
}

