/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.docs;

import crazydev.common.utils.CdPathEscapeUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.ux.admin.queries.docs.UxAbstractDocsQueryMeta;
import crazydev.iccube.ux.admin.queries.docs.UxDocsDownloadQuery;
import crazydev.iccube.ux.admin.queries.docs.UxDocsEntryPath;
import crazydev.iccube.ux.admin.queries.docs.UxDocsRepositoryType;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.action.UxActionBuilder;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.common.url.UxUrl;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxDocsDownloadQueryMeta
extends UxAbstractDocsQueryMeta {
    public static final UxDocsDownloadQueryMeta DocsDownload = new UxDocsDownloadQueryMeta();

    protected UxDocsDownloadQueryMeta() {
        super(UxConsoleConstants.QueryName.DocsDownload);
    }

    @Override
    public boolean isReplyAttached() {
        return true;
    }

    @Override
    public UxQuery parseQuery(UxServerRequestParams params) throws UxQueryParserException {
        UxDocsRepositoryType repositoryType = params.getEnumParameter(UxDocsRepositoryType.class, "repo");
        UxDocsEntryPath path = params.getPathParameter("path");
        ArrayList<String> names = new ArrayList<String>();
        String value = params.getStringParameter("names");
        if (CdStringUtils.isNotNullAndNotBlank((String)value)) {
            String[] entries;
            for (String entry : entries = value.split("\\|")) {
                if (!CdStringUtils.isNotNullAndNotBlank((String)entry)) continue;
                names.add(CdPathEscapeUtils.unescapeUuidName((String)entry));
            }
        }
        return new UxDocsDownloadQuery(this, params.getRequestId(), repositoryType, path, names);
    }

    public UxUrl createQueryUrl(UxDocsRepositoryType repositoryType, @Nullable UxDocsEntryPath path, List<String> names) {
        UxUrl url = this.createQueryUrl().addParam("repo", repositoryType.name()).addParam("path", path);
        StringBuilder value = new StringBuilder();
        for (int ii = 0; ii < names.size(); ++ii) {
            String name = names.get(ii);
            String name_ = CdPathEscapeUtils.escapeUuidName((String)name);
            if (ii > 0) {
                value.append("|");
            }
            value.append(name_);
        }
        url = url.addParam("names", value.toString());
        return url;
    }

    @Nullable
    public static UxAction createAction(UxQueryContext context, @Nullable String id, UxDocsRepositoryType repositoryType, @Nullable UxDocsEntryPath path, @Nullable List<String> names) {
        if (names == null || names.isEmpty()) {
            return null;
        }
        String okCancelMessage = null;
        if (id != null && names.size() == 1) {
            UxBabylonService babylon = context.getUxBabylonService();
            okCancelMessage = babylon.translateActionCaption(id + ".okCancel", (Serializable)((Object)names.get(0)));
        }
        return new UxActionBuilder(context, DocsDownload).withId(id != null ? id : UxDocsDownloadQueryMeta.DocsDownload.queryName.name()).withUrl(DocsDownload.createQueryUrl(repositoryType, path, names)).withOkCancel(okCancelMessage).build();
    }
}

