/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.docs;

import crazydev.common.fs.CdVFileSystem;
import crazydev.iccube.fs.OlapAttachment;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.fs.OlapFileSystem;
import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorException;
import crazydev.iccube.gwt.server.reporting.repository.IOlapDocsRequestContext;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsRepository;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.docs.UxAbstractDocsQuery;
import crazydev.iccube.ux.admin.queries.docs.UxDocsEntryPath;
import crazydev.iccube.ux.admin.queries.docs.UxDocsRepositoryType;
import crazydev.iccube.ux.admin.queries.utils.UxFileWrapper;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxAttachmentReply;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxDocsDownloadQuery
extends UxAbstractDocsQuery {
    private final UxDocsRepositoryType repositoryType;
    @Nullable
    private final UxDocsEntryPath path;
    @Nullable
    private final List<String> names;

    public UxDocsDownloadQuery(UxQueryMeta meta, OlapRequestId requestId, UxDocsRepositoryType repositoryType, @Nullable UxDocsEntryPath path, @Nullable List<String> names) {
        super(meta, requestId);
        this.repositoryType = repositoryType;
        this.path = path;
        this.names = names;
    }

    @Override
    protected UxReply doExecuteQuery(UxQueryContext queryContext) throws OlapDocsErrorException {
        OlapPath absPath;
        IOlapDocsRequestContext docsContext;
        if (this.names == null || this.names.isEmpty()) {
            return UxReply.actionSuccess();
        }
        Object repository = queryContext.getDocsRepository(this.repositoryType);
        OlapAttachment attachment = ((OlapDocsRepository)repository).download(docsContext = queryContext.createDocsRequestContext(), absPath = UxDocsDownloadQuery.setupOlapPath(this.path), this.names);
        if (attachment == null) {
            return UxReply.actionSuccess();
        }
        String mimeType = queryContext.getMimeTypeByExtension(attachment.file.getName());
        OlapFileSystem fs = OlapFileSystem.createFileSystem((CdVFileSystem)queryContext.getVfs(), (File)attachment.file.getParentFile());
        OlapFile zip_ = fs.create(attachment.file.getName());
        UxFileWrapper wrapper = UxFileWrapper.forOlapFile(zip_, attachment.attachmentName, mimeType, true);
        return new UxAttachmentReply(wrapper, null);
    }
}

