/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.docs;

import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.ux.admin.queries.UxAdminQueryMeta;
import crazydev.iccube.ux.admin.queries.docs.UxDocsEntryPath;
import crazydev.iccube.ux.admin.queries.docs.UxDocsQueryMeta;
import crazydev.iccube.ux.admin.queries.docs.UxDocsRepositoryType;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.usecase.UxUseCaseBreadcrumb;
import crazydev.iccube.ux.common.usecase.UxUseCaseBreadcrumbItem;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class UxAbstractDocsQueryMeta
extends UxAdminQueryMeta {
    protected UxAbstractDocsQueryMeta(UxConsoleConstants.QueryName name) {
        super(name);
    }

    @Override
    public String[] getGroup() {
        return new String[]{"docs"};
    }

    @Override
    public boolean isAuthorized(UxQueryContext context) {
        return this.isReaderAuthorized(context);
    }

    protected boolean isReaderAuthorized(UxQueryContext context) {
        OlapRoleApplicationPermissions perms = context.getApplicationPermissions();
        return perms.isReportDocManagementReaderEnabled();
    }

    protected boolean isEditorAuthorized(UxQueryContext context) {
        OlapRoleApplicationPermissions perms = context.getApplicationPermissions();
        return perms.isReportDocManagementEditorEnabled();
    }

    protected boolean isAdminAuthorized(UxQueryContext context) {
        OlapRoleApplicationPermissions perms = context.getApplicationPermissions();
        return perms.isReportDocManagementAdministratorEnabled();
    }

    @Nullable
    protected static UxUseCaseBreadcrumb setupUseCaseBreadcrumb(UxQueryContext context, UxDocsRepositoryType repositoryType, @Nullable UxDocsEntryPath path) {
        ArrayList<UxUseCaseBreadcrumbItem> items = new ArrayList<UxUseCaseBreadcrumbItem>();
        UxBabylonService babylon = context.getUxBabylonService();
        items.add(new UxUseCaseBreadcrumbItem(switch (repositoryType) {
            case UxDocsRepositoryType.FILE_SYSTEM_ROOT -> babylon.translate("docsFileSystem", new Serializable[0]);
            case UxDocsRepositoryType.WEB_PUBLIC -> babylon.translate("docsWebPub", new Serializable[0]);
            case UxDocsRepositoryType.WEB_DOCS -> babylon.translate("docsDocs", new Serializable[0]);
            default -> repositoryType.name();
        }, UxDocsQueryMeta.createUseCase(context, repositoryType, OlapPath.ROOT)));
        if (path != null) {
            List<String> names = path.getNames();
            for (int ii = 0; ii < names.size(); ++ii) {
                items.add(new UxUseCaseBreadcrumbItem(names.get(ii), UxDocsQueryMeta.createUseCase(context, repositoryType, path.toOlapPath(ii))));
            }
        }
        return new UxUseCaseBreadcrumb(items);
    }
}

