/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.docs;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.exception.ICdException;
import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorException;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorRuntimeException;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsDoc;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsEntity;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsLabel;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsLabelPath;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsSharing;
import crazydev.iccube.gwt.server.reporting.repository.IOlapDocsRequestContext;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsRepository;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.UxAdminQuery;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorReplyPayload;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.reply.payload.UxReplyStatus;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public abstract class UxAbstractDocsQuery
extends UxAdminQuery {
    public UxAbstractDocsQuery(UxQueryMeta meta, OlapRequestId requestId) {
        super(meta, requestId);
    }

    @Override
    protected final UxReply executeQuery(UxQueryContext queryContext) {
        try {
            return this.doExecuteQuery(queryContext);
        }
        catch (OlapDocsErrorException | OlapDocsErrorRuntimeException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[UX] docs error", (Throwable)ex);
            String localized = ((ICdException)ex).getError().asMessage((CdBabylonService)queryContext.getOlapBabylonService());
            return new UxPayloadReply(UxReplyStatus.ERROR, new UxErrorReplyPayload("ERROR", localized));
        }
    }

    protected abstract UxReply doExecuteQuery(UxQueryContext var1) throws OlapDocsErrorException;

    @Nullable
    protected static String setupPermissionsTooltip(UxBabylonService babylon, OlapDocsRepository repository, IOlapDocsRequestContext docsContext, OlapDocsEntity entity) throws OlapDocsErrorException {
        if (!repository.isWebRepository()) {
            return null;
        }
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        Profile profile = new Profile();
        OlapPath absPath = OlapPath.createFromUUID((String)entity.getUuid());
        UxAbstractDocsQuery.setupProfile(repository, docsContext, absPath, entity, profile, sb, lineSeparator);
        if (profile.isEmpty()) {
            return null;
        }
        StringBuilder tooltip = new StringBuilder();
        for (Info info : profile.perms) {
            tooltip.append(info.role).append(" [ ").append(info.perms).append(" ] ").append(lineSeparator);
        }
        if (profile.inheritOff.isTrue()) {
            if (!profile.perms.isEmpty()) {
                tooltip.append(lineSeparator);
            }
            tooltip.append(babylon.translate("applyInheritedPermissions", new Serializable[0])).append(" : ").append(babylon.translate("no", new Serializable[0])).append(lineSeparator);
        }
        if (!profile.inheritedPerms.isEmpty()) {
            if (!profile.perms.isEmpty() || profile.inheritOff.isTrue()) {
                tooltip.append(lineSeparator);
            }
            tooltip.append("--").append(lineSeparator).append(babylon.translate("inheritedPermissions", new Serializable[0])).append(lineSeparator).append("--").append(lineSeparator);
            for (Info info : profile.inheritedPerms) {
                tooltip.append(lineSeparator).append(info.where).append(" : ").append(info.role).append(" [ ").append(info.perms).append(" ] ");
            }
        }
        return tooltip.toString();
    }

    protected static void setupProfile(OlapDocsRepository repository, IOlapDocsRequestContext docsContext, OlapPath path, OlapDocsEntity entity, @Nullable Profile profile, StringBuilder sb, String lineSeparator) throws OlapDocsErrorException {
        List<OlapDocsSharing> sharings;
        OlapDocsDoc file;
        boolean inherit;
        UxAbstractDocsQuery.help(sb, lineSeparator);
        sb.append(lineSeparator).append(lineSeparator);
        if (entity instanceof OlapDocsDoc && !(inherit = (file = (OlapDocsDoc)entity).isApplyInheritedPermissions())) {
            sb.append("- inherit").append(lineSeparator);
            if (profile != null) {
                profile.inheritOff.setValue(true);
            }
        }
        if ((sharings = entity.getSharings()) != null) {
            for (OlapDocsSharing sharing : sharings) {
                String roleName = sharing.getRoleName();
                String perms = sharing.getPermissions().name();
                sb.append("+ [").append(roleName).append("] ").append(perms).append(lineSeparator);
                if (profile == null) continue;
                profile.perms.add(new Info("", roleName, perms));
            }
        }
        UxAbstractDocsQuery.setupInheritedProfile(repository, docsContext, path, entity, profile, sb, lineSeparator);
    }

    protected static void setupInheritedProfile(OlapDocsRepository repository, IOlapDocsRequestContext docsContext, OlapPath path, OlapDocsEntity entity, @Nullable Profile profile, StringBuilder sb, String lineSeparator) throws OlapDocsErrorException {
        if (entity instanceof OlapDocsDoc && !((OlapDocsDoc)entity).isApplyInheritedPermissions()) {
            return;
        }
        OlapPath pPath = path.getParent();
        if (pPath == null) {
            return;
        }
        boolean first = true;
        List<OlapDocsLabel> labels = repository.getInheritedLabelSharings(docsContext, new OlapDocsLabelPath(pPath));
        for (OlapDocsLabel label : labels) {
            List<OlapDocsSharing> sharings = label.getSharings();
            if (sharings == null || sharings.isEmpty()) continue;
            if (first) {
                sb.append(lineSeparator).append(lineSeparator).append("-- For your information, here are the inherited permissions:").append(lineSeparator);
                first = false;
            }
            String where = label.getLabelUuid();
            sb.append("-- ").append(lineSeparator).append("--   defined in : ").append(where).append(lineSeparator);
            for (OlapDocsSharing sharing : sharings) {
                String roleName = sharing.getRoleName();
                String perms = sharing.getPermissions().name();
                sb.append("--     + [").append(roleName).append("] ").append(perms).append(lineSeparator);
                if (profile == null) continue;
                profile.inheritedPerms.add(new Info(where, roleName, perms));
            }
        }
    }

    protected static void help(StringBuilder sb, String lineSeparator) {
        sb.append("-- " + lineSeparator + "-- Permissions are defined using a profile made of lines (similar to role's definitions). " + lineSeparator + "-- " + lineSeparator + "--   switch off inherited permissions (file only):" + lineSeparator + "--   - inherit " + lineSeparator + "-- " + lineSeparator + "--   grant READ access for role role-x:" + lineSeparator + "--   + [role-x] READ " + lineSeparator + "-- " + lineSeparator + "--   grant WRITE access for role role-y:" + lineSeparator + "--   + [role-y] WRITE " + lineSeparator);
    }

    static class Profile {
        final List<Info> perms = new ArrayList<Info>();
        final MutableBoolean inheritOff = new MutableBoolean();
        final List<Info> inheritedPerms = new ArrayList<Info>();

        Profile() {
        }

        public boolean isEmpty() {
            return this.perms.isEmpty() && this.inheritedPerms.isEmpty() && this.inheritOff.isFalse();
        }
    }

    static class Info {
        final String where;
        final String role;
        final String perms;

        public Info(String where, String role, String perms) {
            this.where = where;
            this.role = role;
            this.perms = perms;
        }
    }
}

