/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.dashboards;

import crazydev.iccube.ux.admin.queries.dashboards.UxDashboardsInstallVersionQuery;
import crazydev.iccube.ux.admin.queries.reporting.UxReportingHelper;
import crazydev.iccube.ux.admin.queries.reporting.UxReportingVersionInfo;
import crazydev.iccube.ux.admin.queries.runtime.UxRuntimeQueryMeta;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.action.UxActionBuilder;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxDashboardsInstallVersionQueryMeta
extends UxRuntimeQueryMeta {
    public static final UxDashboardsInstallVersionQueryMeta DashboardsInstallVersion = new UxDashboardsInstallVersionQueryMeta();

    private UxDashboardsInstallVersionQueryMeta() {
        super(UxConsoleConstants.QueryName.DashboardsInstallVersion);
    }

    @Override
    public boolean isAuthorized(UxQueryContext context) {
        return super.isAuthorized(context) && context.isAdministrator();
    }

    @Override
    public UxQuery parseQuery(UxServerRequestParams params) {
        return new UxDashboardsInstallVersionQuery(this, params.getRequestId());
    }

    @Nullable
    public static UxAction createAction(UxQueryContext context) {
        UxReportingVersionInfo version = UxReportingHelper.availableDashboardsVersion(context);
        if (version == null) {
            return null;
        }
        UxBabylonService babylon = context.getUxBabylonService();
        String caption = babylon.translateActionCaption("DashboardsInstallVersion", new Serializable[]{version.kitVersion});
        String okCancelMessage = babylon.translateActionCaption("DashboardsInstallVersion.okCancel", new Serializable[]{version.kitVersion, version.installedVersion});
        UxConsoleConstants.QueryName id = version.isNewer ? UxConsoleConstants.QueryName.DashboardsInstallVersion : UxConsoleConstants.QueryName.DashboardsInstallOldVersion;
        return new UxActionBuilder(context, DashboardsInstallVersion).withPlacement(1).withCaption(caption).withOkCancel(okCancelMessage).withId(id.name()).build();
    }

    @Nullable
    public static UxAction createActionIfNewer(UxQueryContext context) {
        UxReportingVersionInfo version = UxReportingHelper.availableDashboardsVersion(context);
        if (version == null || !version.isNewer) {
            return null;
        }
        UxBabylonService babylon = context.getUxBabylonService();
        String caption = babylon.translate("dashboardsInstallServerVersion", new Serializable[]{version.kitVersion});
        String okCancelMessage = babylon.translateActionCaption("DashboardsInstallVersion.okCancel", new Serializable[]{version.kitVersion, version.installedVersion});
        return new UxActionBuilder(context, DashboardsInstallVersion).withCaption(caption).withOkCancel(okCancelMessage).build();
    }
}

