/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.configuration.properties;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.collection.CdPair;
import crazydev.common.utils.CdNetworkUtils;
import crazydev.common.utils.CdSizeUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.configuration.component.OlapUserDefinedProperties;
import crazydev.iccube.configuration.component.OlapUserDefinedProperty;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.configuration.component.properties.OlapProperty;
import crazydev.iccube.configuration.component.properties.OlapPropertyDescriptions;
import crazydev.iccube.crac.CRaCUtils;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.embedded.IcCubeEngineHelper;
import crazydev.iccube.gwt.server.reporting.component.OlapReportingComponentConfiguration;
import crazydev.iccube.gwt.server.reporting.repository.docs.OlapDocsActualRepository;
import crazydev.iccube.gwt.server.requesthandler.reporting.OlapReportRepositoryRequestContext;
import crazydev.iccube.info.OlapLixContent;
import crazydev.iccube.info.OlapLixVerifier;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.runtime.OlapRuntime;
import crazydev.iccube.runtime.OlapRuntimeDashboardsVersion;
import crazydev.iccube.server.IcCubeServerHelper;
import crazydev.iccube.server.configuration.IcCubeServerConfiguration;
import crazydev.iccube.server.configuration.IcCubeServerProperties;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.server.gvi.GviComponentConfiguration;
import crazydev.iccube.server.http.IcCubeHttpComponentConfiguration;
import crazydev.iccube.server.print.IcCubePrintComponentConfiguration;
import crazydev.iccube.server.version.IcCubeServerVersion;
import crazydev.iccube.server.xmla.IcCubeXmlaComponentConfiguration;
import crazydev.iccube.ux.admin.queries.UxAdminQuery;
import crazydev.iccube.ux.admin.queries.configuration.properties.UxServerConfType;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxAttachmentReply;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.table.UxPropertyTableReplyPayload;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.conf.UxApiComponentConfiguration;
import crazydev.iccube.ux.processor.conf.UxComponentConfiguration;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.tools.ToolProvider;
import org.jetbrains.annotations.Nullable;

public class UxServerServerConfQuery
extends UxAdminQuery {
    @Nullable
    private final String configurationType;
    @Nullable
    private final UxTableOptions tableOptions;
    private final boolean download;
    @Nullable
    private UxUseCase useCase;

    protected UxServerServerConfQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String configurationType, @Nullable UxTableOptions tableOptions, boolean download) {
        super(meta, requestId);
        this.configurationType = configurationType;
        this.tableOptions = tableOptions;
        this.download = download;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        @Nullable UxServerConfType configurationType_ = UxServerConfType.Version;
        if (this.configurationType != null) {
            try {
                configurationType_ = UxServerConfType.valueOf(this.configurationType);
            }
            catch (IllegalArgumentException ex) {
                OlapLoggers.UX_REQUEST.error((Object)("[UX] " + this.meta.queryName().name() + " error"), (Throwable)ex);
            }
        }
        List<UxTableRow> infos = switch (configurationType_) {
            case UxServerConfType.Cluster -> {
                this.useCase = queryContext.getUseCase(UxAdminUseCaseName.ServerConfCluster);
                yield UxServerServerConfQuery.createClusterInfos(queryContext);
            }
            case UxServerConfType.Directories -> {
                this.useCase = queryContext.getUseCase(UxAdminUseCaseName.ServerConfDirectories);
                yield UxServerServerConfQuery.createDirectoryInfos(queryContext);
            }
            case UxServerConfType.JavaProperties -> {
                this.useCase = queryContext.getUseCase(UxAdminUseCaseName.ServerConfJavaProperties);
                yield UxServerServerConfQuery.createJavaPropertyInfos(queryContext);
            }
            case UxServerConfType.License -> {
                this.useCase = queryContext.getUseCase(UxAdminUseCaseName.ServerConfLicense);
                yield UxServerServerConfQuery.createLicenseInfos(queryContext);
            }
            case UxServerConfType.NetworkInterfaces -> {
                this.useCase = queryContext.getUseCase(UxAdminUseCaseName.ServerConfNetworkInterfaces);
                yield UxServerServerConfQuery.createNetworkInfos(queryContext);
            }
            case UxServerConfType.OlapProperties -> {
                this.useCase = queryContext.getUseCase(UxAdminUseCaseName.ServerConfOlapProperties);
                yield UxServerServerConfQuery.createOlapEnginePropertyInfos(queryContext);
            }
            case UxServerConfType.ServerProperties -> {
                this.useCase = queryContext.getUseCase(UxAdminUseCaseName.ServerConfServerProperties);
                yield UxServerServerConfQuery.createServerPropertyInfos(queryContext);
            }
            case UxServerConfType.UserDefinedProperties -> {
                this.useCase = queryContext.getUseCase(UxAdminUseCaseName.ServerConfUserDefinedProperties);
                yield UxServerServerConfQuery.createUserDefinedPropertyInfos(queryContext);
            }
            default -> {
                this.useCase = queryContext.getUseCase(UxAdminUseCaseName.ServerConfVersion);
                yield UxServerServerConfQuery.createVersionInfos(queryContext);
            }
        };
        UxBabylonService babylon = queryContext.getUxBabylonService();
        UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.create());
        UxTableHeaders header = UxTableHeaders.create(babylon, "property", "value");
        UxTable table = UxTable.create(!this.download ? options : null, header, infos);
        if (this.download) {
            return new UxAttachmentReply(table.asFileWrapper(queryContext), "ic3-server-conf-" + String.valueOf((Object)configurationType_) + ".csv");
        }
        return UxReply.success(new UxPropertyTableReplyPayload(table));
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        if (this.useCase != null) {
            reply.withUseCase(this.useCase);
        } else {
            reply.withUseCase(queryContext.getUseCase(UxAdminUseCaseName.ServerConfUnknown));
        }
    }

    private static List<UxTableRow> createDirectoryInfos(UxQueryContext queryContext) {
        IcCubeServerApplicationContext appContext = queryContext.getApplicationContext();
        OlapRuntime runtime = appContext.getRuntime();
        OlapDirectoriesResolved directories = queryContext.asRuntimeContext().getDirectoriesResolved();
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        rows.add(UxTableRow.createAsPreValue("icCube.install", runtime.getInstallDirectory().getAbsolutePath()));
        rows.add(UxTableRow.createAsPreValue("data", directories.getDataDirectory().getAbsolutePath()));
        rows.add(UxTableRow.createAsPreValue("audit", directories.getAuditDirectory().getAbsolutePath()));
        rows.add(UxTableRow.createAsPreValue("backup", directories.getBackupDirectory().getAbsolutePath()));
        rows.add(UxTableRow.createAsPreValue("builder", directories.getBuilderDirectory().getAbsolutePath()));
        rows.add(UxTableRow.createAsPreValue("cubes", directories.getCubesDirectory().getAbsolutePath()));
        rows.add(UxTableRow.createAsPreValue("log (*)", IcCubeEngineHelper.getLogDirectoryValue()));
        File multiTenantDirectory = directories.getMultiTenantDirectory();
        if (queryContext.isWithMultiTenant() && multiTenantDirectory != null) {
            rows.add(UxTableRow.createAsPreValue("multiTenant", multiTenantDirectory.getAbsolutePath()));
        }
        rows.add(UxTableRow.createAsPreValue("offline", directories.getOfflineDirectory().getAbsolutePath()));
        rows.add(UxTableRow.createAsPreValue("plugins", directories.getPluginsDirectory().getAbsolutePath()));
        IcCubeServerProperties serverProperties = queryContext.getServerProperties();
        File additional = serverProperties.getAdditionalPlugins();
        if (additional != null) {
            rows.add(UxTableRow.createAsPreValue("plugins (add.)", additional.getAbsolutePath()));
        }
        rows.add(UxTableRow.createAsPreValue("repository (Docs)", directories.getDocsRepositoryDirectory().getAbsolutePath()));
        rows.add(UxTableRow.createAsPreValue("roles", directories.getRolesDirectory().getAbsolutePath()));
        rows.add(UxTableRow.createAsPreValue("scheduler", directories.getSchedulerDirectory().getAbsolutePath()));
        rows.add(UxTableRow.createAsPreValue("schema data", directories.getSchemaDataDirectory().getAbsolutePath()));
        File tenantsDirectory = directories.getTenantsDirectory();
        if (queryContext.isWithMultiTenant() && tenantsDirectory != null) {
            rows.add(UxTableRow.createAsPreValue("tenants", tenantsDirectory.getAbsolutePath()));
        }
        rows.add(UxTableRow.createAsPreValue("tmp", directories.getTmpDirectory().getAbsolutePath()));
        rows.add(UxTableRow.createAsPreValue("users", directories.getUsersDirectory().getAbsolutePath()));
        rows.add(UxTableRow.createAsPreValue("Web (public)", directories.getWebPubDirectory().getAbsolutePath()));
        return rows;
    }

    private static List<UxTableRow> createNetworkInfos(UxQueryContext queryContext) {
        UxApiComponentConfiguration rest;
        UxBabylonService babylon = queryContext.getUxBabylonService();
        boolean isForRestApi = queryContext.isForRestApi();
        IcCubeServerApplicationContext appContext = queryContext.getApplicationContext();
        IcCubeServerConfiguration configuration = appContext.getConfiguration();
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        IcCubeHttpComponentConfiguration httpConfiguration = configuration.getHttpConfiguration();
        String hostname = httpConfiguration != null ? CdNetworkUtils.getHostname((String)httpConfiguration.getHostName()) : "n/a";
        UxComponentConfiguration ux = configuration.getUxConfiguration();
        UxApiComponentConfiguration uxApiComponentConfiguration = rest = ux != null ? ux.getRestApiConf() : null;
        if (rest == null) {
            rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "restApiHttp"), babylon.translate_(isForRestApi, "notEnabled")));
        } else if (httpConfiguration == null) {
            rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "restApiHttp"), babylon.translate_(isForRestApi, "notEnabled")));
        } else {
            String url = "/icCube/api";
            if (httpConfiguration.getPortNumber() != -1) {
                rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "restApiHttp"), "http://" + hostname + ":" + httpConfiguration.getPortNumber() + "/icCube/api"));
            }
            if (httpConfiguration.getSslPortNumber() != -1) {
                rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "restApiHttps"), "https://" + hostname + ":" + httpConfiguration.getSslPortNumber() + "/icCube/api"));
            }
        }
        IcCubeXmlaComponentConfiguration xmla = configuration.getXmlaConfiguration();
        if (xmla == null) {
            rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "xmlaHttp"), babylon.translate_(isForRestApi, "notEnabled")));
        } else {
            String http = xmla.getHttpUrl();
            if (httpConfiguration == null || http.isEmpty()) {
                rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "xmlaHttp"), babylon.translate_(isForRestApi, "notEnabled")));
            } else {
                String info;
                String string = info = !isForRestApi ? " -- " + babylon.translate("xmlaHttpInfo", new Serializable[0]) : "";
                if (httpConfiguration.getPortNumber() != -1) {
                    rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "xmlaHttp"), "http://" + hostname + ":" + httpConfiguration.getPortNumber() + http + info));
                }
                if (httpConfiguration.getSslPortNumber() != -1) {
                    rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "xmlaHttps"), "https://" + hostname + ":" + httpConfiguration.getSslPortNumber() + http + info));
                }
            }
        }
        OlapReportingComponentConfiguration reportConfiguration = configuration.getReportingConfiguration();
        if (httpConfiguration != null && reportConfiguration != null) {
            List<String> urls = reportConfiguration.getUrls();
            if (urls.isEmpty()) {
                rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "docs"), babylon.translate_(isForRestApi, "notEnabled")));
                rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "webReporting"), babylon.translate_(isForRestApi, "notEnabled")));
            } else {
                for (String url : urls) {
                    if (httpConfiguration.getPortNumber() != -1) {
                        rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "docsHttp"), "http://" + hostname + ":" + httpConfiguration.getPortNumber() + url));
                    }
                    if (httpConfiguration.getSslPortNumber() == -1) continue;
                    rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "docsHttps"), "https://" + hostname + ":" + httpConfiguration.getSslPortNumber() + url));
                }
                if (httpConfiguration.getPortNumber() != -1) {
                    rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "webReportingHttp"), "http://" + hostname + ":" + httpConfiguration.getPortNumber() + "/icCube/doc/ic3report"));
                }
                if (httpConfiguration.getSslPortNumber() != -1) {
                    rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "webReportingHttps"), "https://" + hostname + ":" + httpConfiguration.getSslPortNumber() + "/icCube/doc/ic3report"));
                }
            }
        } else {
            rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "docs"), babylon.translate_(isForRestApi, "notEnabled")));
            rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "webReporting"), babylon.translate_(isForRestApi, "notEnabled")));
        }
        GviComponentConfiguration gviConfiguration = configuration.getGviConfiguration();
        if (httpConfiguration != null && gviConfiguration != null) {
            String url = gviConfiguration.getUrl();
            if (CdStringUtils.isNullOrBlank((String)url)) {
                rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "gvi"), babylon.translate_(isForRestApi, "notEnabled")));
            } else {
                if (httpConfiguration.getPortNumber() != -1) {
                    rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "gviHttp"), "http://" + hostname + ":" + httpConfiguration.getPortNumber() + url));
                }
                if (httpConfiguration.getSslPortNumber() != -1) {
                    rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "gviHttps"), "https://" + hostname + ":" + httpConfiguration.getSslPortNumber() + url));
                }
            }
        } else {
            rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "gvi"), babylon.translate_(isForRestApi, "notEnabled")));
        }
        IcCubePrintComponentConfiguration printConfiguration = configuration.getPrintConfiguration();
        if (httpConfiguration != null && printConfiguration != null && printConfiguration.isPrintOnServerActive()) {
            String url = printConfiguration.getUrl();
            if (CdStringUtils.isNullOrBlank((String)url)) {
                rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "printOnServer"), babylon.translate_(isForRestApi, "notEnabled")));
            } else {
                if (httpConfiguration.getPortNumber() != -1) {
                    rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "printOnServerHttp"), "http://" + hostname + ":" + httpConfiguration.getPortNumber() + url));
                }
                if (httpConfiguration.getSslPortNumber() != -1) {
                    rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "printOnServerHttps"), "https://" + hostname + ":" + httpConfiguration.getSslPortNumber() + url));
                }
            }
        } else {
            rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "printOnServer"), babylon.translate_(isForRestApi, "notEnabled")));
        }
        return rows;
    }

    private static List<UxTableRow> createOlapEnginePropertyInfos(UxQueryContext queryContext) {
        String value;
        PrintStream ps;
        ByteArrayOutputStream out2;
        IcCubeServerApplicationContext appContext = queryContext.getApplicationContext();
        IcCubeServerConfiguration configuration = appContext.getConfiguration();
        OlapProperties engineProperties = configuration.getOlapEngineConfiguration().getProperties();
        Iterable validatedProperties = engineProperties.getValidatedProperties();
        ArrayList<OlapProperty> sortedProperties = new ArrayList<OlapProperty>();
        for (Object validatedProperty : validatedProperties) {
            sortedProperties.add((OlapProperty)validatedProperty);
        }
        Collections.sort(sortedProperties, new Comparator<OlapProperty>(){

            @Override
            public int compare(OlapProperty o1, OlapProperty o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        for (OlapProperty property : sortedProperties) {
            String name = property.getDescription().getName();
            Object value2 = String.valueOf(property.getValue());
            if (name.equals(OlapPropertyDescriptions.olapEngineSimultaneousRequestCount.getName())) {
                value2 = (String)value2 + " (actual:" + engineProperties.getOlapEngineSimultaneousRequestCount() + ")";
            } else if (name.equals(OlapPropertyDescriptions.loadReadingThreadCount.getName())) {
                value2 = (String)value2 + " (actual:" + engineProperties.getLoadReadingThreadCount() + ")";
            } else if (name.equals(OlapPropertyDescriptions.loadProcessingThreadCount.getName())) {
                value2 = (String)value2 + " (actual:" + engineProperties.getLoadProcessingThreadCount() + ")";
            } else if (name.equals(OlapPropertyDescriptions.factFileSize.getName())) {
                value2 = (String)value2 + " (actual:" + (engineProperties.getFactFileSize() == -1 ? "no limit" : CdSizeUtils.format((double)(1 << engineProperties.getFactFileSize()))) + ")";
            } else if (name.equals(OlapPropertyDescriptions.factFileBufferSize.getName())) {
                value2 = (String)value2 + " (actual:" + CdSizeUtils.format((double)(1 << engineProperties.getFactFileBufferSize())) + ")";
            } else if (name.equals(OlapPropertyDescriptions.cleanerFileCount.getName())) {
                value2 = (String)value2 + " (actual:" + String.valueOf(engineProperties.getCleanerFileCount() == -1 ? "no limit" : Integer.valueOf(engineProperties.getCleanerFileCount())) + ")";
            }
            if (name.equals(OlapPropertyDescriptions.activeMdxRequestCount.getName()) || name.equals(OlapPropertyDescriptions.singleMdxEvalThreadCount.getName()) || name.equals(OlapPropertyDescriptions.singleMdxEvalQueueSize.getName()) || name.equals(OlapPropertyDescriptions.singleMdxExtraEvalThreadCount.getName()) || name.equals(OlapPropertyDescriptions.singleMdxExtraEvalQueueSize.getName())) continue;
            rows.add(UxTableRow.createAsPre(name, (String)value2));
        }
        try {
            out2 = new ByteArrayOutputStream();
            ps = new PrintStream((OutputStream)out2, true, "UTF-8");
            IcCubeServerHelper.logBackupProperties(ps, configuration, false);
            ps.flush();
            value = new String(out2.toByteArray());
            rows.add(UxTableRow.createAsPreValue("Backup Configuration", value));
        }
        catch (UnsupportedEncodingException out2) {
            // empty catch block
        }
        try {
            out2 = new ByteArrayOutputStream();
            ps = new PrintStream((OutputStream)out2, true, "UTF-8");
            IcCubeServerHelper.logMdxProperties(ps, configuration, false);
            ps.flush();
            value = new String(out2.toByteArray());
            rows.add(UxTableRow.createAsPreValue("MDX Evaluation Configuration", value));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return rows;
    }

    private static List<UxTableRow> createServerPropertyInfos(UxQueryContext queryContext) {
        IcCubeServerApplicationContext appContext = queryContext.getApplicationContext();
        IcCubeServerConfiguration configuration = appContext.getConfiguration();
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        String serverId = configuration.getId();
        List<CdPair<String, String>> properties = configuration.getProperties().getOrderedProperties();
        rows.add(UxTableRow.createAsPre("id", serverId));
        for (CdPair<String, String> property : properties) {
            rows.add(UxTableRow.createAsPre((String)property.fst, (String)property.snd));
        }
        return rows;
    }

    private static List<UxTableRow> createUserDefinedPropertyInfos(UxQueryContext queryContext) {
        boolean unsafe;
        boolean bl = unsafe = !queryContext.isAdministrator();
        if (unsafe) {
            return new ArrayList<UxTableRow>();
        }
        IcCubeServerApplicationContext appContext = queryContext.getApplicationContext();
        IcCubeServerConfiguration configuration = appContext.getConfiguration();
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        OlapUserDefinedProperties properties = configuration.getUserDefinedProperties();
        for (OlapUserDefinedProperty property : properties.getProperties()) {
            rows.add(UxTableRow.createAsPre(property.getName(), property.getValue()));
        }
        return rows;
    }

    private static List<UxTableRow> createJavaPropertyInfos(UxQueryContext queryContext) {
        boolean unsafe = !queryContext.isAdministrator();
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        boolean hasJDK = ToolProvider.getSystemJavaCompiler() != null;
        String status = queryContext.getUxBabylonService().translate(hasJDK ? "yesL" : "noL", new Serializable[0]);
        rows.add(UxTableRow.createAsPre("JDK Installed", status));
        rows.add(UxTableRow.createAsPre("Java CRaC", String.valueOf(CRaCUtils.withCRaC())));
        Properties properties = System.getProperties();
        ArrayList<String> names = new ArrayList<String>();
        for (Object key : properties.keySet()) {
            names.add(String.valueOf(key));
        }
        names.sort(String::compareTo);
        for (String name : names) {
            if (unsafe && !name.startsWith("file.") && !name.startsWith("java.") && !name.startsWith("line.") && !name.startsWith("native.") && !name.startsWith("os.") && !name.startsWith("path.") && !name.startsWith("stderr.") && !name.startsWith("stdout.") && !name.startsWith("sun.") && !name.startsWith("user.")) continue;
            rows.add(UxTableRow.createAsPre(name, properties.getProperty(name)));
        }
        return rows;
    }

    private static List<UxTableRow> createLicenseInfos(UxQueryContext queryContext) {
        IcCubeServerApplicationContext appContext = queryContext.getApplicationContext();
        OlapEngineApplicationContext engineAppContext = appContext.getOlapEngineApplicationContext();
        OlapEngineComponent engineComponent = engineAppContext.getOlapEngineComponent();
        OlapLixContent lix = engineComponent.getLixContent();
        Map infos = OlapLixVerifier.createInfos((CdBabylonService)queryContext.getOlapBabylonService(), (OlapLixContent)lix);
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        for (Map.Entry entry : infos.entrySet()) {
            rows.add(UxTableRow.createAsPreValue((String)entry.getKey(), (String)entry.getValue()));
        }
        return rows;
    }

    private static List<UxTableRow> createClusterInfos(UxQueryContext queryContext) {
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        if (queryContext.isInCluster()) {
            UxBabylonService babylon = queryContext.getUxBabylonService();
            rows.add(UxTableRow.create(babylon.translate("active", new Serializable[0]), babylon.translate("yes", new Serializable[0])));
        }
        return rows;
    }

    private static List<UxTableRow> createVersionInfos(UxQueryContext queryContext) {
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        rows.add(UxTableRow.create("Server", IcCubeServerVersion.get().toString()));
        try {
            OlapDocsActualRepository repository = queryContext.getDocsRepository();
            OlapReportRepositoryRequestContext repReqCtxt = queryContext.createRepositoryContext();
            OlapRuntimeDashboardsVersion reportingVersion = repository.getDashboardsVersion(repReqCtxt);
            if (reportingVersion != null) {
                rows.add(UxTableRow.create("Dashboards", reportingVersion.getVersionWithTimestamp()));
            } else {
                UxBabylonService babylon = queryContext.getUxBabylonService();
                rows.add(UxTableRow.create("Dashboards", babylon.translate("reportingVersionNA", new Serializable[0])));
            }
        }
        catch (RuntimeException ex) {
            OlapLoggers.UX_REQUEST.warn((Object)"[UX] could not retrieve reporting version", (Throwable)ex);
        }
        return rows;
    }
}

