/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.configuration.properties;

import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.ux.admin.queries.UxAdminQueryMeta;
import crazydev.iccube.ux.admin.queries.configuration.properties.UxServerConfType;
import crazydev.iccube.ux.admin.queries.configuration.properties.UxServerServerConfQuery;
import crazydev.iccube.ux.admin.queries.download.UxDownloadQueryMeta;
import crazydev.iccube.ux.admin.queries.utils.UxArrays;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.url.UxUrl;
import crazydev.iccube.ux.common.url.UxUrlConstants;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxServerConfQueryMeta
extends UxAdminQueryMeta {
    public static final UxServerConfQueryMeta ServerConf = new UxServerConfQueryMeta();

    public UxServerConfQueryMeta() {
        this(UxConsoleConstants.QueryName.ServerConf);
    }

    protected UxServerConfQueryMeta(UxConsoleConstants.QueryName name) {
        super(name);
    }

    @Override
    public String[] getGroup() {
        return new String[]{"configuration"};
    }

    @Override
    public UxUrl helpUrl() {
        return UxUrlConstants.HELP_NETWORK_ENDPOINTS;
    }

    @Nullable
    public List<UxAction> createActions(UxQueryContext context, UxServerConfType configurationType) {
        return UxArrays.asList(UxDownloadQueryMeta.createAction(context, ServerConf, this.createQueryUrl(configurationType), 0));
    }

    @Override
    public boolean isAuthorized(UxQueryContext context) {
        OlapRoleApplicationPermissions perms = context.getApplicationPermissions();
        return super.isAuthorized(context) && perms.isMonitoringConfigurationEnabled();
    }

    @Override
    public UxQuery parseQuery(UxServerRequestParams params) throws UxQueryParserException {
        String configurationType = params.getStringParameter("name");
        UxTableOptions tableOptions = params.getTableOptions();
        boolean download = params.getBooleanParameter("download");
        return new UxServerServerConfQuery(this, params.getRequestId(), configurationType, tableOptions, download);
    }

    public UxUrl createQueryUrl(UxServerConfType configurationType) {
        return this.createQueryUrl().addParam("name", configurationType.name());
    }
}

